

CREATE OR REPLACE FUNCTION TBeleg.Update_DokumentSumme(IN beldokid INTEGER) RETURNS VOID AS $$ -- TWawi. => DROP nicht mehr nötig
 DECLARE docnetto NUMERIC;
         docnetto_basis_w NUMERIC;
         docbrutto NUMERIC;
         docbrutto_basis_w NUMERIC;
         docskonto NUMERIC;
         docsteuer NUMERIC;
         docbezahlt NUMERIC;
         docAbzuNetto NUMERIC;
 BEGIN
   SELECT TBeleg.DokumentSumme(beldokid, FALSE,  TRUE, TRUE, FALSE, FALSE) INTO docnetto; -- Netto-Dok. Summe (mit Abzu und Rabatten)
   SELECT TBeleg.DokumentSumme(beldokid, FALSE, FALSE, TRUE, FALSE, FALSE) INTO docbrutto; -- Brutto-Dok. Summe (mit Abzu und Rabatten)
   SELECT TBeleg.DokumentSumme(beldokid, FALSE, FALSE, TRUE, TRUE, FALSE)  INTO docskonto; -- Skontierte Dok. Summe (mit Abzu und Rabatten)
   --
   SELECT TBeleg.DokumentSumme(beldokid, TRUE,  TRUE, TRUE, FALSE, FALSE) INTO docnetto_basis_w; -- Netto-Dok. Summe (mit Abzu und Rabatten)
   SELECT TBeleg.DokumentSumme(beldokid, TRUE, FALSE, TRUE, FALSE, FALSE) INTO docbrutto_basis_w; -- Brutto-Dok. Summe (mit Abzu und Rabatten)
   --
   docsteuer:=docbrutto-docnetto;
   docskonto:=docbrutto-docskonto;
   docbezahlt:= COALESCE( (SELECT SUM(belzlg_betrag) FROM belegzahlung WHERE belzlg_dokument_id = beldokid AND belzlg_gebucht),0);
   --
   UPDATE belegdokument SET beld_netto = docnetto, beld_netto_basis_w = docnetto_basis_w, beld_brutto = docbrutto, beld_brutto_basis_w = docbrutto_basis_w, beld_steuer = docsteuer, beld_skonto = docskonto,beld_bezahlt = docbezahlt WHERE beld_id = beldokid;
   --

   -- Dokumentab- / Zuschläge in Netto oder Brutto
   SELECT SUM( (COALESCE(belaz_betrag, 0)*belaz_anzahl) )
          INTO docAbzuNetto FROM belegabzu WHERE belaz_dokument_id = beldokid;

   -- Beleg-Nettosumme abzueglich Ab/Zuschlaege  => Positionssumme mit Positionsabzuschlaegen
   -- im Verhaeltnis zu Positions-Nettosumme = Anteil der Pos. an BelegAbzuschlaegen
   UPDATE belegpos SET belp_sumBelegAbzu = COALESCE ( ( belp_netto / do1if0(( docnetto - COALESCE(docAbzuNetto,0) )) ) * docAbzuNetto,0)
          WHERE belp_dokument_id = beldokid AND belp_sumbelegAbzu <> COALESCE ( ( belp_netto / do1if0(( docnetto - COALESCE(docAbzuNetto,0) )) ) * docAbzuNetto,0) ;

 END $$ LANGUAGE plpgsql;


-- ID zur Dokument-Nr. und Belegtyp holen.
CREATE OR REPLACE FUNCTION TBeleg.GetDokumentId(IN beltyp VARCHAR, IN beldoknr VARCHAR) RETURNS INTEGER AS $$ -- TWawi => wahrscheinlich DROP
 BEGIN
   RETURN beld_id FROM belegdokument WHERE beld_belegtyp = beltyp AND beld_dokunr = beldoknr;
 END $$ LANGUAGE plpgsql STABLE;

--  Pos-Nr zur Belegpositions-ID holen
CREATE OR REPLACE FUNCTION TBeleg.GetPosNummer(IN belpid INTEGER) RETURNS INTEGER AS $$ -- TSystem_Wawi.beleg_k__k_nummer__from__p_id
 BEGIN
   RETURN belp_pos FROM belegpos WHERE belp_id =belpid;
 END $$ LANGUAGE plpgsql STABLE;

--  Dokument-Nr zur beld_id holen
CREATE OR REPLACE FUNCTION TBeleg.GetDokumentNrFromPos(IN belpid INTEGER) RETURNS VARCHAR AS $$ -- TSystem_Wawi.beleg_k__k_nummer__from__p_id
 BEGIN
   RETURN TBeleg.GetDokumentNr(belp_dokument_id) FROM belegpos WHERE belp_id =belpid;
 END $$ LANGUAGE plpgsql STABLE;

--  Dokument-Nr zur beld_id holen
CREATE OR REPLACE FUNCTION TBeleg.GetDokumentNr(IN beldid INTEGER) RETURNS VARCHAR AS $$ -- TSystem_Wawi.beleg_k__k_nummer__from__k_id
 BEGIN
   RETURN beld_dokunr FROM belegdokument WHERE beld_id =beldid;
 END $$ LANGUAGE plpgsql STABLE;

--
CREATE OR REPLACE FUNCTION TBeleg.GetDokumentNrAndDatumFromPos(IN belpid INTEGER, OUT dokunr VARCHAR, OUT erstelldatum DATE) RETURNS RECORD AS $$ -- TSystem_Wawi.beleg_k__k_nummer__erstelldatum__from__p_id
 BEGIN
  SELECT COALESCE(beld_dokunr,''), beld_erstelldatum INTO dokunr, erstelldatum
         FROM belegdokument JOIN belegpos ON beld_id = belp_dokument_id
         WHERE belp_id = belpid;
  RETURN;
 END $$ LANGUAGE plpgsql STABLE;


--Bekommt Beleg_id, gibt Betrag nach Kontenaufteilung und zugehoerigen Steuercode zurueck
CREATE OR REPLACE FUNCTION TBeleg.GetKontenAufteilung(
    IN  _beldid integer,
    IN  _fillup__ks_konto__from__firstpos boolean DEFAULT true,
    OUT beldid integer,
    OUT steucode integer,
    OUT konto varchar, -- Position
    OUT ks varchar,  -- Position
    OUT summe numeric,
    OUT summe_basisw numeric
    )
    RETURNS SETOF record
    AS $$
    DECLARE
      result record;
      _kurs numeric;
      _firstpos_kto varchar;
      _firstpos_ks varchar;
      _beld_rund numeric;
    BEGIN

       --_Kurs aus erster Position für Belegabzuschlaege bei Fremdwaehrung (analog GetDokumentSumme, ExportReady)
       SELECT coalesce(belp_kurs, 1), belp_konto, belp_kostenstelle
         INTO _kurs, _firstpos_kto, _firstpos_ks
         FROM belegpos
        WHERE belp_dokument_id = _beldid
        ORDER BY belp_pos
          ASC LIMIT 1;

       IF NOT _fillup__ks_konto__from__firstpos THEN
          _firstpos_kto := null;
          _firstpos_ks  := null;
       END IF;

       FOR result IN (
                      SELECT steu, knt, kst, SUM( brutto) AS brutto, SUM(brutto_basisw) as brutto_basisw
                      FROM
                      (
                        --BELEGPOS = belp_brutto OHNE Abzuschlaege
                        ( SELECT
                              belp_steucode AS steu,
                              coalesce(belp_kostenstelle, _firstpos_ks) AS kst,
                              coalesce(belp_konto, steu_konto, _firstpos_kto) AS knt,
                              (belp_preis_gme_basis_w * belp_menge_gme
                                      * (1 + belp_steuproz / 100)
                                      * IfThen( (belp_rabattfaehig),(1 - belp_rabatt / 100), 1)
                                      / IfThen(belp_kurs=0,1,belp_kurs)) as brutto,
                              (belp_preis_gme_basis_w * belp_menge_gme
                                      * (1 + belp_steuproz / 100)
                                      * IfThen( (belp_rabattfaehig),(1 - belp_rabatt / 100), 1)
                                      ) as brutto_basisw
                          FROM belegpos
                          LEFT JOIN steutxt ON steu_z = belp_steucode
                          WHERE belp_dokument_id = $1 --AND coalesce(belp_konto, steu_konto)  IS NOT NULL --macht das sinn? kein konto sollte auch einfach kein konto sein?! 2012-08-15 DS
                        )
                      UNION ALL
                        --BELEGABZUSCHLAEGE
                        ( SELECT
                            belaz_steucode     AS steu,
                            coalesce(belaz_ks_abt, _firstpos_ks)  AS belp_kostenstelle,
                            coalesce(belaz_konto, steu_konto, _firstpos_kto) AS knt,
                            belaz_anzahl * belaz_betrag * ( 1 + belaz_steuproz / 100)      AS Brutto,
                            belaz_anzahl * belaz_betrag * ( 1 + belaz_steuproz / 100) * IfThen(_kurs = 0, 1, _kurs) AS Brutto_basisw
                          FROM belegabzu
                          LEFT JOIN steutxt ON steu_z = belaz_steucode
                          WHERE belaz_dokument_id = $1 --AND coalesce(belaz_konto, steu_konto) IS NOT NULL
                        )
                      UNION ALL
                        --BELEGPOSABZUSCHLAEGE
                        ( SELECT
                              belpaz_steucode     AS steu,
                              coalesce(belp_kostenstelle, _firstpos_ks) AS belp_kostenstelle,
                              coalesce(belpaz_konto, belp_konto, steu_konto, _firstpos_kto) AS knt,
                              belpaz_anzahl * belpaz_betrag * ( 1 + belpaz_steuproz / 100) AS Brutto,
                              belpaz_anzahl * belpaz_betrag * ( 1 + belpaz_steuproz / 100) * IfThen(belp_kurs = 0, 1, belp_kurs) AS Brutto_basisw
                          FROM belegposabzu
                          LEFT JOIN belegpos ON belpaz_belegpos_id = belp_id
                          LEFT JOIN steutxt  ON steu_z = belpaz_steucode
                          WHERE belp_dokument_id = $1 --AND coalesce(belpaz_konto, steu_konto) IS NOT NULL
                        )
                      ) AS subTable1
                      GROUP BY  knt, steu, kst
                      ORDER BY  knt
                    )
       LOOP

         --RAISE NOTICE 'Konto: % . Betrag: % ', kontierung, betrag;

         beldid       := _beldid;
         steucode     := result.steu;
         konto        := result.knt;
         summe        := result.brutto;
         summe_basisw := result.brutto_basisw;
         ks           := result.kst;

         IF tsystem.settings__getbool( 'eingrech_rund', true ) THEN
           _beld_rund := beld_rund FROM eingrech WHERE beld_id = _beldid;
           summe := num_round_by_precision_rule( summe, _beld_rund );
           summe_basisw := num_round_by_precision_rule( summe_basisw, _beld_rund );
         END IF;

         RETURN NEXT;
       END LOOP;

    END $$ LANGUAGE plpgsql STABLE;


/*TRIGGER KONTROLLE FÜR DIE EINZELNEN BELEGTABELLEN*/

CREATE OR REPLACE FUNCTION disableBelDokTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF TSystem.current_user_in_syncro_dblink() THEN
         RETURN;
  END IF;
  varname:=current_user||'beldok_off';
  PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
  PERFORM disablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableBelDokTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF TSystem.current_user_in_syncro_dblink() THEN
         RETURN;
  END IF;
  varname:=current_user||'beldok_off';
  PERFORM TSystem.Settings__Set(varname, CAST(numeric_larger(0,TSystem.Settings__GetInteger(varname)-1) AS VARCHAR));
  PERFORM enablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION BelDokTriggerOff() RETURNS BOOL AS $$
 DECLARE varname VARCHAR;
 BEGIN
  varname:=current_user||'beldok_off';
  RETURN TSystem.Settings__GetInteger(varname)>0;
 END$$LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION disableBelPosTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF TSystem.current_user_in_syncro_dblink() THEN
         RETURN;
  END IF;
  varname:=current_user||'belpos_off';
  PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
  PERFORM disablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableBelPosTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF TSystem.current_user_in_syncro_dblink() THEN
         RETURN;
  END IF;
  varname:=current_user||'belpos_off';
  PERFORM TSystem.Settings__Set(varname, CAST(numeric_larger(0,TSystem.Settings__GetInteger(varname)-1) AS VARCHAR));
  PERFORM enablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION BelPosTriggerOff() RETURNS BOOL AS $$
 DECLARE varname VARCHAR;
 BEGIN
  varname:=current_user||'belpos_off';
  RETURN TSystem.Settings__GetInteger(varname)>0;
 END$$LANGUAGE plpgsql;




CREATE OR REPLACE FUNCTION disableBelAbzuTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF  TSystem.current_user_in_syncro_dblink()  THEN
         RETURN;
  END IF;
  varname:=current_user||'belabzu_off';
  PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
  PERFORM disablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableBelAbzuTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF  TSystem.current_user_in_syncro_dblink()  THEN
         RETURN;
  END IF;
  varname:=current_user||'belabzu_off';
  PERFORM TSystem.Settings__Set(varname, CAST(numeric_larger(0,TSystem.Settings__GetInteger(varname)-1) AS VARCHAR));
  PERFORM enablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION BelAbzuTriggerOff() RETURNS BOOL AS $$
 DECLARE varname VARCHAR;
 BEGIN
  varname:=current_user||'belabzu_off';
  RETURN TSystem.Settings__GetInteger(varname)>0;
 END$$LANGUAGE plpgsql;




CREATE OR REPLACE FUNCTION disableBelPosAbzuTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF TSystem.current_user_in_syncro_dblink() THEN
         RETURN;
  END IF;
  varname:=current_user||'belposabzu_off';
  PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
  PERFORM disablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableBelPosAbzuTrigger() RETURNS VOID AS $$
 DECLARE varname VARCHAR;
 BEGIN
  IF TSystem.current_user_in_syncro_dblink() THEN
         RETURN;
  END IF;
  varname:=current_user||'belposabzu_off';
  PERFORM TSystem.Settings__Set(varname, CAST(numeric_larger(0,TSystem.Settings__GetInteger(varname)-1) AS VARCHAR));
  PERFORM enablemodified();
  RETURN;
 END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION BelPosAbzuTriggerOff() RETURNS BOOL AS $$
 DECLARE varname VARCHAR;
 BEGIN
  varname:=current_user||'belposabzu_off';
  RETURN TSystem.Settings__GetInteger(varname)>0;
 END$$LANGUAGE plpgsql;




-- Prüfen woher die Belegposition stammt und eine Bezeichnung für den Vorgänger zusammenbauen.
CREATE OR REPLACE FUNCTION TBeleg.GetVorgaengerBez(IN _belpid integer) RETURNS varchar AS $$
 DECLARE _rec    record;
         _lagAbg varchar;
         _bez    varchar;
         _s      varchar;
 BEGIN

   SELECT belp_vorgaenger,belp_ld_id, belp_ag_id, belp_w_wen, belp_l_nr, belp_q_nr, belp_belegtyp,belp_ab_ix, belp_a2_id, w_zug_dat::date, w_lgort INTO _rec
     FROM belegpos LEFT JOIN wendat ON w_wen = belp_w_wen
    WHERE belp_id = _belpid;


   IF _rec.belp_vorgaenger IS NOT NULL THEN
      SELECT (beld_dokunr || ' / ' ||belp_pos)
        INTO _bez
        FROM belegpos JOIN belegdokument ON belp_dokument_id = beld_id
       WHERE belp_id = _rec.belp_vorgaenger;
   END IF;

   --Eingangsrechnungs-Vorgaenger
   IF _rec.belp_belegtyp = 'ERG' THEN

     --Mit ABK und AG sollte das Rechnung auf Auswaertsvergabe sein ...
     If (_rec.belp_ab_ix IS NOT NULL) AND (_rec.belp_a2_id IS NOT NULL) THEN
       SELECT ('ABK: ' || _rec.belp_ab_ix || ' AG: ' || a2_n )
         INTO _bez
         FROM ab2
        WHERE a2_id = _rec.belp_a2_id;
     END IF;

     --Bestellung mit Anzeigen
     If _rec.belp_ld_id IS NOT NULL THEN
       IF coalesce(_bez,'') <> '' THEN
         _s := _bez;
         SELECT (ld_code || ' / ' || ld_auftg || ' / ' || ld_pos)
                 || CASE WHEN ld_q_nr IS NOT NULL THEN ' => QAB '||ld_q_nr::varchar ELSE '' END
           INTO _bez
           FROM ldsdok
          WHERE ld_id = _rec.belp_ld_id;

         _bez := _bez || ' => ' || _s; -- Bestellnummer => ABK 123 AG 50
                                  -- oder 'E/20130265/13 => QAB 5436'
       ELSE
         SELECT (ld_code || ' / ' || ld_auftg || ' / ' || ld_pos),ld_q_nr
                 || CASE WHEN ld_q_nr IS NOT NULL THEN ' => QAB '||ld_q_nr::varchar ELSE '' END
           INTO _bez
           FROM ldsdok
          WHERE ld_id = _rec.belp_ld_id;
       END IF;


     END IF;
     --Wareneingang mit dazu
     If _rec.belp_w_wen IS NOT NULL THEN
       _bez := 'WE: ' || _rec.belp_w_wen || ' (' || _rec.w_zug_dat || ') '  || _rec.w_lgort || ' => ' || coalesce(_bez,'');
     END IF;
   --Ende Eingangsrechnung
   END IF;


   --Lieferschein-Vorgaenger
   IF _rec.belp_belegtyp = 'LFS' THEN

     -- Auftragsbezogener Lagerabgang
     If _rec.belp_ag_id IS NOT NULL THEN
         SELECT (ag_astat || ' / ' || ag_nr || ' / ' || ag_pos)
           INTO _bez
           FROM auftg
          WHERE ag_id = _rec.belp_ag_id;
     END IF;

     -- Wenn LFS und belp_w_wen, war das Retoure auf Wareneingang
     IF _rec.belp_w_wen IS NOT NULL THEN
       _bez:= 'WE: ' || _rec.belp_w_wen || ' (' || _rec.w_zug_dat || ') ' || _rec.w_lgort ;
     END IF;

     -- QAB der Retoure auslöste: QAB: 1000 => WE: 212395
     IF _rec.belp_q_nr IS NOT NULL THEN
       _bez:= 'QAB: ' || _rec.belp_q_nr  || ' => ' || coalesce(_bez, '');
     END IF;


     SELECT array_to_string(array_agg(l_nr::varchar),',')
       INTO _lagAbg
       FROM (SELECT l_nr
               FROM lifsch
              WHERE l_belp_id = _belpid
              ORDER BY l_nr)
            AS lagabgOrder;

     If coalesce(_lagAbg, '') <> '' THEN
        _bez := 'LA: ' || _lagAbg || ' => ' || coalesce(_bez, '');
     END IF;  ----> Lagerabgang: LA: 1002,1003,1007 => I/AUFT10232/20 oder    LA: 1002323 => QAB: 1000 => WE: 21395

   --Ende Lieferschein
   END IF;

   RETURN _bez;
 END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;


/****************************Summe über ein Belegdokument*****************************************/

/* Ab- und Zuschläge werden bisher immer mit übernommen, auch wenn "calcOffen" vllt. sagt wir sollen nur noch nicht übernommene einrechnen */
CREATE OR REPLACE FUNCTION TBeleg.DokumentSumme(IN beldokid INTEGER,
                                IN in_basis_w BOOLEAN,
                                IN calcNetto BOOLEAN ,   -- Brutto oder Netto
                                IN calcRabatt BOOLEAN,   -- Rabatt berücksichtigen oder nicht
                                IN calcSkonto BOOLEAN,   -- Skonto berücksichtigen oder nicht
                                IN calcOffen BOOLEAN     -- ACHTUNG: OFFEN bezieht sich NICHT auf Bezahlt / Teilzahlungen, sondern offene vs. erledigte Menge
                                ) RETURNS NUMERIC AS $$
 DECLARE   summe NUMERIC;
         belabzu NUMERIC;
         posabzu NUMERIC;
     skontosatz  NUMERIC;
     belegrabatt NUMERIC;
            _rec RECORD;
        _abzurec RECORD;
        sumold   NUMERIC;
 BEGIN
   summe:=0;

   IF (beldokid IS NULL) THEN
         RETURN 0;
   END IF;

   If calcSkonto THEN
     SELECT COALESCE(beld_sks,0) INTO skontosatz FROM belegdokument WHERe beld_id = beldokid;
   END IF;

   If calcRabatt THEN
      SELECT COALESCE(beld_gesamtrabatt,0) INTO belegrabatt FROM belegdokument WHERe beld_id = beldokid;
   END IF;

   FOR _rec IN SELECT belp_id, belp_beleg_id, belp_dokument_id, belp_preis, belp_menge, belp_preis_gme, belp_menge_gme, belp_menge_done, belp_preiseinheit, belp_kurs, belp_steuproz, belp_rabatt, belp_skontofaehig,belp_rabattfaehig
                 FROM belegpos WHERE belp_dokument_id = beldokid LOOP
         -- Ab-/Zuschläge der Belegposition in Netto oder Brutto
         SELECT SUM(
                         (COALESCE(belpaz_betrag, 0)*belpaz_anzahl)
                         * IfThen( (NOT calcNetto)                  ,(1 + belpaz_steuproz / 100),1)      -- Steuern
                         * IfThen( (calcSkonto AND belpaz_canSkonto),(1 - skontosatz / 100), 1))         -- SkontoSatz
                  INTO posabzu FROM belegposabzu
                  WHERE belpaz_belegpos_id = _rec.belp_id AND TRUE;
                         -- IfThen(((NOT calcOffen) OR (belpaz_folgepos_id IS NULL)), TRUE, FALSE);
                 --ODER     NOT EXISTS(SELECT TRUE FROM belegabzu WHERE belpaz_vorgaenger = belpaz_id)
         posabzu:=COALESCE(posabzu,0); -- In Positionswährung. Kurs wird unten in Gesamtpos.Summe eingerechnet
         -- IfThen(in_basis_w, COALESCE(_rec.belp_kurs,1), 1);

         sumold:=summe;
         -- Summe über bisherige Positionen + neue Position mit Abzubeträgen
         summe:=summe + (((_rec.belp_preis_gme * _rec.belp_menge_gme --/ IfThen(_rec.belp_preiseinheit=0, 1, _rec.belp_preiseinheit)
                 * IfThen( (NOT calcNetto)                        ,(1 + _rec.belp_steuproz/ 100),1)      -- Steuern
                 * IfThen( (calcRabatt AND _rec.belp_rabattfaehig),(1 - belegrabatt / 100), 1)           -- Belegrabatt
                 * IfThen( (calcRabatt AND _rec.belp_rabattfaehig),(1 - _rec.belp_rabatt / 100), 1)      -- Positionsrabatt
                 * IfThen( (calcSkonto AND _rec.belp_skontofaehig),(1 - skontosatz / 100), 1))           -- SkontoSatz
                 * IfThen(  calcOffen, (1 - _rec.belp_menge_done / IfThen(_rec.belp_menge = 0, 1, _rec.belp_menge)) ,1)      -- Übernommene Menge
                    + COALESCE(posabzu,0))
                    * IfThen(in_basis_w, COALESCE(_rec.belp_kurs,1),1 )
                 );
         -- RAISE NOTICE 'Poswert: %', (summe-sumold);

   END LOOP;

   -- Dokumentab- / Zuschläge in Netto oder Brutto
   SELECT SUM(
         (COALESCE(belaz_betrag, 0)*belaz_anzahl)
         * IfThen( (NOT calcNetto)                 ,(1 + belaz_steuproz / 100),1)        -- Steuern
         * IfThen( (calcSkonto AND belaz_canSkonto),(1 - skontosatz / 100), 1))          -- SkontoSatz
       INTO belabzu FROM belegabzu WHERE belaz_dokument_id = beldokid AND TRUE;
        --IfThen(((NOT calcOffen) OR (belaz_folgedokument_id IS NULL)), TRUE, FALSE);

   summe:=COALESCE(Summe,0) + ( COALESCE(belabzu,0) * IfThen(in_basis_w, COALESCE(_rec.belp_kurs,1),1)); -- <== Kurs letzter Position, da es keinen Dokumentenbezogenen Waehrungskurs gibt?
   RETURN Round(COALESCE(summe,0),2);
 END$$LANGUAGE plpgsql STABLE;




/****************************BELEG KOPIEREN***************************** returns neue Belegdokument-ID*/
CREATE OR REPLACE FUNCTION TBeleg.BelegDokumentKopieren(IN beldokid INTEGER, IN newdoknr VARCHAR(30), IN doktable VARCHAR) RETURNS INTEGER AS $$
 DECLARE newdokid        INTEGER;
         beltyp          VARCHAR;
 BEGIN

   --Wir prüfen ob es von dem Belegtyp und mit der Dokument-Nr. schon einen Beleg gibt
   SELECT beld_belegtyp INTO beltyp FROM belegdokument WHERE beld_id = beldokid;
   SELECT beld_id INTO newdokid FROM belegdokument WHERE beld_dokunr = newdoknr AND beld_belegtyp = beltyp;

   --Falls ja, können wir den nicht nochmal einfügen und geben die ID des bestehenden zurück. Dann hängen wir Positionen dort halt an.
   IF newdokid IS NOT NULL THEN
     RETURN newdokid;
   END IF;

   PERFORM disablemodified();
   newdokid:=nextval('belegdokument_beld_id_seq');

   --Daten aus Belegdokument umkopieren, ggf. aus anderer Tabelle (doktable) nehmen
   IF (doktable IS NULL) THEN
     INSERT INTO beldoktmp (SELECT * FROM belegdokument WHERE beld_id = beldokid);
   ELSE
     EXECUTE 'INSERT INTO beldoktmp (SELECT * FROM ' || doktable || ' WHERE beld_id = ' || beldokid ||' ) ';
   END IF;

   --Belegdokument - Schlüssel, StatusFlags und Werte neu vergeben beziehungsweise zurücksetzen
   UPDATE beldoktmp SET
         dbrid = nextval('db_id_seq'), beld_id = newdokid,beld_dokunr = newdoknr,
         beld_refbeleg = NULL, beld_bezahlt = 0, beld_definitiv = FALSE, beld_freigabe = FALSE, beld_verbucht = FALSE, beld_geprueft = FAlSE,
         beld_erstelldatum = current_date, beld_abschlussdatum = NULL, beld_exportdatum = NULL,
         insert_by = current_user, insert_date = current_date, modified_by = NULL, modified_date = NULL;

   --Zurückschreiben in angegebene doktable
   IF (doktable IS NULL) THEN
     INSERT INTO belegdokument (SELECT * FROM beldoktmp);
   ELSE
     EXECUTE 'INSERT INTO ' || doktable || ' (SELECT * FROM beldoktmp); ';
   END IF;


   PERFORM enablemodified();
   RETURN newdokid;
 END $$ LANGUAGE plpgsql VOLATILE;


/****************************BELEGPOSITION KOPIEREN***************************** returns neue BelegPos-ID*/
CREATE OR REPLACE FUNCTION TBeleg.BelegPosKopieren(IN oldposid INTEGER, IN beldokid INTEGER, IN postable VARCHAR, IN mitPreis BOOLEAN, IN mitMenge BOOLEAN, IN mitVorgaenger BOOLEAN) RETURNS INTEGER AS $$
 DECLARE newposid        INTEGER;
 BEGIN

   PERFORM disablemodified();
   newposid:=nextval('belegpos_belp_id_seq');

   --Daten aus Position umkopieren, ggf. aus anderer Tabelle (doktable) nehmen
   IF (postable IS NULL) THEN
     INSERT INTO belpostmp (SELECT * FROM belegpos WHERE belp_id = oldposid);
   ELSE
     EXECUTE 'INSERT INTO belpostmp (SELECT * FROM ' || postable || ' WHERE belp_id = ' || oldposid ||' ) ';
   END IF;

   --Belegdokument - Schlüssel, StatusFlags und Werte neu vergeben beziehungsweise zurücksetzen
   UPDATE belpostmp SET
         dbrid = nextval('db_id_seq'), belp_id = newposid, belp_dokument_id = beldokid, belp_beleg_id = NULL,
         belp_pos = NULL,
         belp_preis = IfThen(mitPreis,belp_preis,0),
         belp_menge = IfThen(mitMenge,belp_menge,0),
         belp_vorgaenger = oldposid,
         belp_ld_id = IfThen(mitVorgaenger,belp_ld_id,NULL),
         belp_ag_id = IfThen(mitVorgaenger,belp_ag_id,NULL),
         belp_w_wen = IfThen(mitVorgaenger,belp_w_wen,NULL),
         belp_l_nr  = IfThen(mitVorgaenger,belp_l_nr,NULL),  -- (LG,12/2013, nur noch bedingt sinnvoll. Bezug Lagerabgang <> Lief.Pos. gedreht mit Feld l_belp_id, das wird nie kopiert)
         belp_menge_done = 0,
         belp_erstelldatum = current_date,  belp_referenz = NULL,
         belp_erledigt = FALSE, belp_storniert =  FALSE,
         insert_by = current_user, insert_date = current_date, modified_by = NULL, modified_date = NULL;

   --Zurückschreiben in angegebene postable
   IF (postable IS NULL) THEN
     INSERT INTO belegpos (SELECT * FROM belpostmp);
   ELSE
     EXECUTE 'INSERT INTO ' || postable || ' (SELECT * FROM belpostmp); ';
   END IF;

   DELETE FROM belpostmp;
   PERFORM enablemodified();
   RETURN newposid;
 END $$ LANGUAGE plpgsql VOLATILE;


/****************************BELEGAB- UND ZUSCHLAEGE KOPIEREN***************************** returns Anzahl kopierter Abzu*/
CREATE OR REPLACE FUNCTION TBeleg.BelegAbzuKopieren(IN oldbeldokid INTEGER, IN newbeldokid INTEGER) RETURNS INTEGER AS $$
 DECLARE rec             RECORD;
 BEGIN

   PERFORM disablemodified();

   --Belegabzuschlaege in Temp-Tabelle, umschreiben und zurueckschreiben in richtige Tabelle
   INSERT INTO belabzutmp  (SELECT * FROM belegabzu    WHERE belaz_dokument_id = oldbeldokid);

   FOR rec IN SELECT belaz_id FROM belabzutmp LOOP
     UPDATE belabzutmp SET
         dbrid = nextval('db_id_seq'), belaz_id = nextval('belegabzu_belaz_id_seq'),
         belaz_dokument_id = newbeldokid, belaz_vorgaenger = NULL,
         insert_by = current_user, insert_date = current_date, modified_by = NULL, modified_date = NULL
     WHERE belaz_id = rec.belaz_id;
   END LOOP;

   INSERT INTO belegabzu (SELECT * FROM belabzutmp);
   DELETE FROM belabzutmp;

   PERFORM enablemodified();

   RETURN  COALESCE( ( SELECT Count(*) FROM belegabzu WHERE belaz_dokument_id = newbeldokid),0);
 END $$ LANGUAGE plpgsql VOLATILE;


/* TODO: Wird ausschlieࠬich von TFormErgImport.ImportPosition noch verwendet.
  Bei Gelegenheit ersetzen mit TWawi.Abzu_Copy und dann kann die voraussichtlich weg.
  BELEGPOSITIONS-AB- UND ZUSCHLAEGE KOPIEREN***************************** returns Anzahl kopierter Abzu
*/
CREATE OR REPLACE FUNCTION TBeleg.BelegPosAbzuKopieren(IN oldbelpid INTEGER, IN newbelpid INTEGER) RETURNS INTEGER AS $$
 DECLARE rec             RECORD;
 BEGIN

   PERFORM disablemodified();

   --Belegabzuschlaege in Temp-Tabelle, umschreiben und zurueckschreiben in richtige Tabelle
   INSERT INTO belposabzutmp (SELECT belegposabzu.* FROM belegposabzu WHERE belpaz_belegpos_id = oldbelpid);

   FOR rec IN SELECT belpaz_id FROM belposabzutmp LOOP
     UPDATE belposabzutmp SET
         dbrid = nextval('db_id_seq'), belpaz_id = nextval('belegposabzu_belpaz_id_seq'),
         belpaz_belegpos_id = newbelpid, belpaz_vorgaenger = NULL,
         insert_by = current_user, insert_date = current_date, modified_by = NULL, modified_date = NULL
     WHERE belpaz_id = rec.belpaz_id;
   END LOOP;

   INSERT INTO belegposabzu (SELECT * FROM belposabzutmp);
   DELETE FROM belposabzutmp;

   PERFORM enablemodified();

   RETURN  COALESCE( ( SELECT Count(*) FROM belegposabzu WHERE belpaz_belegpos_id = newbelpid),0);
 END $$ LANGUAGE plpgsql VOLATILE;


/****************************BELEGPOS aus WARENEINGANG*****************************/

-- Eingangsrechnungsposition aus Wareneingang
CREATE OR REPLACE FUNCTION TBeleg.BelegPosFromWendatPos(IN belegtyp VARCHAR(3), IN wendatdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$ -- TWawi.beleg_p__rechnunge__from__wendat__create
 DECLARE rec     RECORD;
         docRec     RECORD;
         frei      BOOLEAN;
         belegid INTEGER;
         posid   INTEGER;
         uebernommen NUMERIC;
         uebernahme  NUMERIC;
         menge_gme NUMERIC;
         belpreis  NUMERIC;
         egdatum   DATE;
 BEGIN
  --Freier Wendat Satz?
  SELECT (w_lds_id IS NULL) INTO frei FROM wendat WHERE wendat.dbrid = wendatdbrid;
  --- #8396
  SELECT MAX(e_gdatum) INTO egdatum
  FROM wendat
    JOIN epreis ON e_aknr = w_aknr AND e_lkn = w_l_krz
  WHERE wendat.dbrid = wendatdbrid;


  /* Aktuelles Verhalten (Preis-ME ggf. NULL) [09/2017, LG]
  * 1: Bestellt 20 m für 10 €/m  |  Lagerzugang =  20 m   |  ERG =  20 m  zu 10 €/m     | Menge durchgeben, Preis durchgeben
  * 2: Bestellt 20 m für 10 €/m  |  Lagerzugang = 200 kg  |  ERG = 200 kg zu  1 €/kg    | Menge umrechnen , Preis umrechnen, PME auf Lagerzugangs-ME setzen
  * 3: Bestellt 20 m für  1 €/kg |  Lagerzugang =  20 m   |  ERG =  20 m  zu  1 €/kg    | Menge durchgeben, PME durchgeben
  * 4: Bestellt 20 m für  1 €/kg |  Lagerzugang = 200 kg  |  ERG = 200 kg zu  1 €/kg    | Menge umrechnen , PME durchgeben
  */
  -- Wir sammeln mal alle möglichen Daten im System
  SELECT COALESCE(IfThen(frei, e_preis, ld_preis),0)                  AS preis,        -- ld_ep_uf1 ist in GME umgerechnet und pro ME, also ohne Preiseinheiten.
         COALESCE(IfThen(frei, e_preiseinheit, ld_preiseinheit),1)    AS preiseinheit, -- Preiseinheit, wenn nicht vorhanden ist das immer 1.
         e_mcv,
         w_zug_mec AS me,
         ld_mce,
         COALESCE(IfThen(frei, e_rab, ld_arab),0) AS rabatt,
         IfThen(frei, e_best, ld_bem) AS refAknr,
         IfThen(frei, a2_vers, ltd_vers) AS versart,
         COALESCE(w_zugang,0) AS w_zugang, COALESCE(w_zugang_uf1,0) AS w_zugang_uf1, e_id, ld_id, w_wen, w_aknr, w_l_krz,
         COALESCE(IfThen(frei, e_waer, ld_waer),TSystem.Settings__Get('BASIS_W')) AS waer, w_lfsnr, ltd_gesrab,ld_eklos,
         ld_an_nr, ld_lkontakt, ld_lkontaktkrzl, ld_kontakt, ld_krzl, ld_krzf, ltd_zakbem,
         ltd_apkrzl, ltd_ap, ltd_apint, a2_zahlart,
         m_uf, -- Umrechnungsfaktor von GME -> ME aus Wareneingang
         ld_a2_id,
         COALESCE(ltd_zak, a2_zak) AS zahlkond,
         COALESCE(ltd_sks, a2_sks) AS skontosatz,
         COALESCE(ltd_skv, a2_skv) AS skontotage,
         COALESCE(ld_ks, w_ks, ak_ks, ac_ks) AS ks,
         COALESCE(ld_konto, ak_awko, ac_konto) AS konto,
         COALESCE(ld_akbz, ak_bez) AS akbez,
         --Steuercode: Freier Wareneingang => Kredidaten, sonst Bestellung. Falls nicht vorhanden Artikelspezifsch oder Standard Einkaufssteuer aus Sys.Einstellung
         COALESCE(IfThen(frei, a2_wuco, ld_steucode), ain_steucode_ek, TSystem.Settings__GetInteger('einksteucode')) AS steucode,
         COALESCE(IfThen(frei, steu_proz, ld_steuproz), steu_proz) AS steuproz,
         COALESCE(IfThen(frei,wa_kurs,ld_kurs),1) as wakurs,
         -- Preismengeneinheit
         ld_ekp_mce AS ekp_mec, --NULL zulassen
         ak_canRabatt, ain_canSkonto,
         w_q_nr,
         ldt_txt, ld_txtint, ld_txtint_rtf --Einkaufstexte durchreichen
         INTO rec
         FROM wendat    JOIN art ON w_aknr = ak_nr
                        JOIN artcod ON ak_ac = ac_n
                        JOIN artmgc ON w_zug_mec = m_id
                        JOIN adk ON ad_krz = w_l_krz
                        LEFT JOIN adk2 ON ad_krz = a2_krz
                        LEFT JOIN ldsdok ON w_lds_id = ld_id
                        LEFT JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
                        LEFT JOIN ldsdoktxt     ON ldt_code = ld_code AND ldt_auftg = ld_auftg -- Zusatztext zur Bestellung kommt daher.
                        LEFT JOIN artinfo ON ain_ak_nr = ak_nr
                        --- #8396
                        LEFT JOIN epreis ON e_aknr = w_aknr AND e_lkn = w_l_krz AND e_gdatum = egdatum  --(SELECT MAX(e_gdatum) FROM epreis WHERE e_aknr = w_aknr AND e_lkn = w_l_krz)
                        LEFT JOIN bewa ON wa_einh = COALESCE(IfThen(frei, e_waer, ld_waer),TSystem.Settings__Get('BASIS_W'))
                        LEFT JOIN steutxt ON steu_z = COALESCE(IfThen(frei, a2_wuco, ld_steucode), ain_steucode_ek,  TSystem.Settings__GetInteger('einksteucode'))
         WHERE wendat.dbrid = wendatdbrid;

  belpreis := rec.Preis;
  -- Keine Preismengeneinheit in Bestellung.
  IF rec.ekp_mec IS NULL THEN

    -- Wenn Lagerzugangs-ME <> Bestell-ME müssen wir auf Lagerzugangs-ME umrechnen
    IF (rec.ld_mce IS DISTINCT FROM rec.me) THEN
      -- Umrechnen des Preis von Bestell-ME auf Grund-ME
      belpreis := tartikel.me__preis__in__preis_uf1( rec.ld_mce, belpreis);
      -- Umrechnen auf Lagerzugangs-ME aus dem Wareneingang
      belpreis := tartikel.me__preis_uf1__in__preis  (rec.me,belpreis);
      -- Belegpos-Preis-ME auf Lagerzugangs-ME setzen
      rec.ekp_mec := rec.me;
    END IF;

    -- ELSE
    -- Bestellung hatte eine Preis-ME. Die reichen wir mit dem Preis durch und die Eingangsrechnung wird genauso dargestellt.
    -- Menge wird ggf. Lagerzugangs-ME umgerechnet.
  END IF;

  SELECT * INTO docRec FROM eingrechdokument WHERE beld_dokunr = belegdoknr;

  SELECT bel_id INTO belegid FROM beleg WHERE bel_nummer = belegdoknr AND bel_belegtyp = belegtyp;


  -- Menge ermitteln, die bereits in andere Positionen übernommen wurde
  -- Fall: Teil-Lieferung / -Verrechnung
  -- in GME
  uebernommen :=
        sum( belp_menge_gme )
      FROM eingrech_pos
      WHERE belp_w_wen = rec.w_wen
  ;


  --Zu übernehmende Menge in GME
  menge_gme:=menge / Do1If0(rec.m_uf);

  --Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
  IF (menge IS NULL) THEN
    --Uebernahme ist in ME des Wareneingangs
    uebernahme:=( rec.w_zugang * (1-COALESCE(uebernommen,0) / IfThen(rec.w_zugang_uf1 = 0, 1, rec.w_zugang_uf1)));
  ELSE
    --Wenn mehr übernommen werden soll als zugegangen abzgl. schon uebernommen, auf Restbestand zurücksetzen
    IF ((menge_gme + uebernommen) > rec.w_zugang_uf1) THEN
      uebernahme:=(rec.w_zugang_uf1 - uebernommen)*Ifthen(rec.m_uf=0,1,rec.m_uf);
    ELSE
      uebernahme:=menge;
    END IF;
  END IF;

  IF (uebernahme < 0) THEN
    uebernahme:=0;
  END IF;

  SELECT nextval('belegpos_belp_id_seq') INTO posid;

  --Belegposition mitnehmen
  INSERT INTO eingrech_pos (
    belp_id, belp_belegtyp, belp_dokument_id, belp_beleg_id, belp_ld_id, belp_w_wen,
    belp_skontofaehig, belp_rabattfaehig, belp_konto, belp_kostenstelle, belp_kurs,
    belp_waehr, belp_steucode, belp_steuproz, belp_preis, belp_preiseinheit, belp_rabatt,
    belp_aknr, belp_akbez, belp_referenzaknr, belp_mce, belp_los, belp_projektnummer,
    belp_versandartbem, belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
    belp_menge, belp_a2_id, belp_q_nr, belp_txt, belp_txt_rtf, belp_preis_mce
  ) VALUES (
    posid, belegtyp, docRec.beld_id, belegid, rec.ld_id, rec.w_wen,
    COALESCE(rec.ain_canSkonto,TRUE), rec.ak_canRabatt, rec.konto, rec.ks, rec.wakurs,
    rec.waer, rec.steucode, rec.steuproz, belpreis, Do1If0(COALESCE(rec.preiseinheit,1)), rec.rabatt,
    rec.w_aknr, rec.akbez, rec.refaknr, rec.me, rec.ld_eklos, rec.ld_an_nr,
    rec.versart, COALESCE(rec.ld_krzl, '#'), rec.w_l_krz, rec.w_l_krz, rec.w_lfsnr,
    uebernahme, rec.ld_a2_id, rec.w_q_nr, rec.ld_txtint, rec.ld_txtint_rtf, rec.ekp_mec
  );

  -- Wenn Kopftext Belegdokument noch leer ist, übernehmen wir den "Hinweistext zur Bestellung" aus ldsdoktxt
  IF COALESCE(rec.ldt_txt,'')<>'' THEN
    UPDATE belegdokument SET beld_kopftext = rec.ldt_txt WHERE beld_id = docRec.beld_id AND COALESCE(beld_kopftext,'')='';
  END IF;

  IF frei THEN
    --PERFORM TBeleg.BelegPosAbzuFromEpreis(rec.e_id, posid);
    PERFORM TWawi.Abzu_Copy('Epreis_Abzu', rec.e_id::VARCHAR,  'BelegPos_Abzu', posid::VARCHAR, uebernahme);
  ELSE
    --PERFORM TBeleg.BelegPosAbzuFromLdsdok(rec.ld_id, posid);
    PERFORM TWawi.Abzu_Copy('Ldsdok_Abzu', rec.ld_id::VARCHAR, 'BelegPos_Abzu', posid::VARCHAR, uebernahme);
  END IF;

  RETURN  posid;
 END $$ LANGUAGE plpgsql VOLATILE;
--



/****************************BELEGPOS aus EINKAUFSPOS.*****************************/
CREATE OR REPLACE FUNCTION TBeleg.BelegPosFromLdsDok(IN belegtyp VARCHAR(3), IN ldsdokdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC)  RETURNS INTEGER AS $$ -- TWawi.beleg_p__rechnunge__from__einkauf__create
 DECLARE rec     RECORD;
         docRec     RECORD;
         belegid INTEGER;
         posid   INTEGER;
         uebernommen NUMERIC;
         uebernahme  NUMERIC;
         menge_gme NUMERIC;
 BEGIN

  -- Wir sammeln mal alle möglichen Daten im System
  SELECT COALESCE(ld_preis,0)                  AS preis,
         COALESCE(NullIf(ld_preiseinheit,0),1) AS preiseinheit,
         ld_mce AS me,
         ld_ekp_mce AS pme,
         COALESCE(ld_arab,0) AS rabatt,
         ld_bem AS refAknr,
         ltd_vers AS versart,
         ld_stk,ld_stk_uf1, ld_id, ld_auftg, ld_pos, ld_aknr,ld_kn, ld_krzf, ld_krzl, ld_waer, ltd_gesrab,ld_eklos,
         ld_an_nr, ld_lkontakt, ld_lkontaktkrzl, ld_kontakt, ld_krzl, ld_krzf, ltd_zakbem,
         ltd_apkrzl, ltd_ap, ltd_apint, a2_zahlart, m_uf,
         COALESCE(ltd_zak, 0) AS zahlkond,
         COALESCE(ltd_sks, 0) AS skontosatz,
         COALESCE(ltd_skv, 0) AS skontotage,
         COALESCE(ld_ks, ak_ks, ac_ks) AS ks,
         COALESCE(ld_konto, ak_awko, ac_konto) AS konto,
         COALESCE(ld_akbz,ak_bez) AS akbez,
         COALESCE(ld_steucode, ain_steucode_ek, a2_wuco, TSystem.Settings__GetInteger('einksteucode')) AS steucode,
         COALESCE(ld_steuproz, steu_proz) AS steuproz,
         COALESCE(ld_kurs,wa_kurs,1) as wakurs,
         ak_canRabatt, ain_canSkonto,
         ld_a2_id,
         ld_q_nr,
         ldt_txt, ld_txtint, ld_txtint_rtf --Einkaufstexte durchreichen
         INTO rec
         FROM ldsdok    JOIN art ON ld_aknr = ak_nr
                        JOIN artcod ON ak_ac = ac_n
                        JOIN artmgc ON ld_mce = m_id
                        JOIN adk ON ad_krz = ld_kn
                        LEFT JOIN adk2 ON ad_krz = a2_krz
                        --LEFT JOIN ab2  ON a2_id  = ld_a2_id TODO.
                        --LEFT JOIN op2  ON a2_o2_id = o2_id
                        LEFT JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
                        LEFT JOIN ldsdoktxt     ON ldt_code = ld_code AND ldt_auftg = ld_auftg -- Zusatztext zur Bestellung kommt daher.
                        LEFT JOIN artinfo ON ain_ak_nr = ak_nr
                        LEFT JOIN bewa ON wa_einh = ld_waer
                        LEFT JOIN steutxt ON steu_z = COALESCE(ld_steucode, ain_steucode_ek, a2_wuco,TSystem.Settings__GetInteger('einksteucode'))
         WHERE ldsdok.dbrid = ldsdokdbrid;

  SELECT * INTO docRec FROM eingrechdokument WHERE beld_dokunr = belegdoknr;
  SELECT bel_id INTO belegid FROM beleg WHERE bel_nummer = belegdoknr AND bel_belegtyp = belegtyp;

  -- Übernommen in GME
  SELECT SUM(belp_menge_gme) INTO uebernommen FROM eingrech_pos WHERE belp_ld_id = rec.ld_id;
  --Zu übernehmende Menge in GME
  menge_gme:=menge / Ifthen(rec.m_uf=0,1,rec.m_uf);

  --Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
  IF (menge IS NULL) THEN
    --Uebernahme ist in ME des Wareneingangs
    uebernahme:=( rec.ld_stk * (1-COALESCE(uebernommen,0) / IfThen(rec.ld_stk_uf1 = 0, 1, rec.ld_stk_uf1)));
  ELSE
    --Wenn mehr übernommen werden soll als zugegangen abzgl. schon uebernommen, auf Restbestand zurücksetzen
    IF ((menge_gme + uebernommen) > rec.ld_stk_uf1) THEN
      uebernahme:=(rec.ld_stk_uf1 - uebernommen)*Ifthen(rec.m_uf=0,1,rec.m_uf);
    ELSE
      uebernahme:=menge;
    END IF;
  END IF;

  IF (uebernahme < 0) THEN
    uebernahme:=0;
  END IF;

  SELECT nextval('belegpos_belp_id_seq') INTO posid;

  --Belegposition mitnehmen
  INSERT INTO eingrech_pos (
    belp_id, belp_belegtyp, belp_dokument_id, belp_beleg_id, belp_ld_id,
    belp_skontofaehig, belp_rabattfaehig, belp_konto, belp_kostenstelle, belp_kurs,
    belp_waehr, belp_steucode, belp_steuproz, belp_preis, belp_preiseinheit, belp_rabatt,
    belp_aknr, belp_akbez, belp_referenzaknr, belp_mce, belp_preis_mce, belp_los, belp_projektnummer,
    belp_versandartbem, belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
    belp_menge, belp_a2_id, belp_q_nr, belp_txt, belp_txt_rtf
  ) VALUES (
    posid, belegtyp, docRec.beld_id, belegid, rec.ld_id,
    COALESCE(rec.ain_canSkonto,TRUE), rec.ak_canRabatt, rec.konto, rec.ks, rec.wakurs,
    rec.ld_waer, rec.steucode, rec.steuproz, rec.preis, rec.preiseinheit, rec.rabatt,
    rec.ld_aknr, rec.akbez, rec.refaknr, rec.me, rec.pme, rec.ld_eklos, rec.ld_an_nr,
    rec.versart, rec.ld_krzl, rec.ld_kn, rec.ld_kn, rec.ld_auftg||'/'||rec.ld_pos,
    uebernahme, rec.ld_a2_id, rec.ld_q_nr, rec.ld_txtint, rec.ld_txtint_rtf
  );

  -- Wenn Kopftext Belegdokument noch leer ist, übernehmen wir den "Hinweistext zur Bestellung" aus ldsdoktxt
  IF COALESCE(rec.ldt_txt,'')<>'' THEN
    UPDATE belegdokument SET beld_kopftext = rec.ldt_txt WHERE beld_id = docRec.beld_id AND COALESCE(beld_kopftext,'')='';
  END IF;

  --PERFORM TBeleg.BelegPosAbzuFromLdsdok(rec.ld_id, posid);
  PERFORM TWawi.Abzu_Copy('Ldsdok_Abzu', rec.ld_id::VARCHAR, 'BelegPos_Abzu', posid::VARCHAR, uebernahme);

  RETURN  posid;
 END $$ LANGUAGE plpgsql VOLATILE;
--


/* [03/2018] Rausgeworfen mit ݢerarbeitung Zuschl娥 https://redmine.prodat-sql.de/issues/8219
   CREATE OR REPLACE FUNCTION TBeleg.BelegPosAbzuFromLdsdok(IN ldid INTEGER, IN belposid INTEGER)
   CREATE OR REPLACE FUNCTION TBeleg.BelegPosAbzuFromEpreis(IN eid INTEGER, IN belposid INTEGER)
*/

/**************************** BELEGPOS aus Auswärtsarbeitsgang ***************************4456**/
CREATE OR REPLACE FUNCTION TBeleg.BelegPosFromAuswaertsAG(IN belegtyp VARCHAR(3), IN a2id INTEGER, IN belegdoknr VARCHAR(30), IN menge NUMERIC = NULL) RETURNS INTEGER AS $$
 DECLARE rec     RECORD;
      docRec     RECORD;
         belegid INTEGER;
         posid   INTEGER;
     uebernommen NUMERIC;
     gesamtmenge NUMERIC;
     uebernahme  NUMERIC;
     ausschuss   NUMERIC;
 BEGIN

 -- Wir sammeln mal alle möglichen Daten zum Arbeitsgang
   SELECT * INTO docRec FROM belegdokument WHERE beld_belegtyp = belegtyp AND beld_dokunr = belegdoknr;

   SELECT
       COALESCE(a2_awpreis,o2_awpreis, 0) AS stkPreis,              -- Preis pro Mengeneinheit wie in ABK/ASK
       COALESCE(o2_awpreisfix,0)          AS fixPreis,              -- Fixpreis mitnehmen?
       tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(a2_aknr)           AS me,                    -- 11.12.2017, LG: Geändert auf ME des Arbeitspakets. Belegpostrigger prüft mittlerweile ob ME zum Artikel der Belegpos passt.
                                                                    -- Früher: Standardmengeneinheit des Fert.Artikels  #8679
       ab_st_uf1 AS gesamt,
       -- Nur Zusammenrechnen, was Auswärts-AP ist, damit zusätzliche Speditionsrechnungen und Kram nicht mit-summiert werden
       ab_st_uf1,
       ab_an_nr,
       fertData.*,
       a2_adkrz,
       COALESCE(a2_ks, ak_ks, ac_ks) AS ks,                        -- ??? Das ist eigentlich die Buchungskostenstelle oder?
       COALESCE(ak_awko, ac_konto)   AS konto,
       COALESCE(steu_proz, 0)        AS steuproz,
       COALESCE(a2_wuco, ain_steucode_ek, TSystem.Settings__GetInteger('einksteucode')) AS steucode,
       ak_canRabatt, ain_canSkonto,
       a2_vers AS versart,
       a2_aknr
       INTO rec
          FROM
             (SELECT (tabk.abk__fertdata__by__a2_id(a2id)).*) as fertData
             JOIN ab2    ON fertdata.a2_id=ab2.a2_id
             JOIN abk    ON ab2.a2_ab_ix=ab_ix
             JOIN art    ON a2_aknr = ak_nr
                 JOIN artcod ON ak_ac = ac_n
             LEFT JOIN adk     ON ad_krz = docrec.beld_krzlieferung
             LEFT JOIN adk2    ON ad_krz = a2_krz
             LEFT JOIN artinfo ON ain_ak_nr = ak_nr
             LEFT JOIN op2     ON op2.o2_id=fertData.o2_id
             LEFT JOIN steutxt ON steu_z = COALESCE(a2_wuco, ain_steucode_ek, TSystem.Settings__GetInteger('einksteucode'))
          WHERE ab2.a2_id=a2id;

   -- Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
   IF (menge IS NULL) THEN
     -- Bereits übernommene in GME
     SELECT SUM(belp_menge_gme) INTO uebernommen FROM eingrech_pos WHERE belp_a2_id = a2id AND belp_aknr = rec.a2_aknr;

     -- Rückgemeldete Menge des Vorarbeitsganges
     SELECT TplanTerm.rm_menge( TPlanTerm.prev_ag(rec.a2_id)) INTO gesamtmenge;

     -- Ausschuss, der für diesen AG schon bekannt ist (da AuswaertsAG nur zutreffend, wenn manuell in RM gepflegt wurde. Eingangsrechnung kennt keinen Ausschuss)
     SELECT Tplanterm.rm_ausschuss(a2id) INTO ausschuss;

     -- Offene Menge = Rückgemeldete Menge (oder Fert.Menge) - bereits verrechnete Menge
     uebernahme:= COALESCE(gesamtmenge,rec.gesamt) - COALESCE(uebernommen,0) - COALESCE(ausschuss,0);
   ELSE
     uebernahme:=menge;
   END IF;

   IF (uebernahme < 0) THEN
     uebernahme:=0;
   END IF;

   SELECT nextval('belegpos_belp_id_seq') INTO posid;

   --Belegposition für die Stück-Bearbeitung
   INSERT INTO belegpos (
     belp_id, belp_belegtyp, belp_dokument_id, belp_beleg_id, belp_a2_id,
     belp_skontofaehig, belp_rabattfaehig, belp_konto, belp_kostenstelle, belp_kurs,
     belp_waehr, belp_steucode, belp_steuproz, belp_preis, belp_rabatt,
     belp_aknr, belp_akbez, belp_mce, belp_projektnummer,
     belp_versandartbem, belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_menge, belp_menge_gme,
     belp_txt
   ) VALUES (
     posid, belegtyp, docRec.beld_id, belegid, rec.a2_id,
     COALESCE(rec.ain_canSkonto,TRUE), rec.ak_canRabatt, rec.konto, rec.ks, 1,
     TSystem.Settings__Get('BASIS_W'), rec.steucode, rec.steuproz, rec.stkpreis, 0,
     rec.apaknr, rec.apakbez, rec.me, rec.ab_an_nr,
     rec.versart, '#', docrec.beld_krzlieferung, docrec.beld_krzlieferung, uebernahme, uebernahme,
     lang_text(29198) /*'Automatisch erstellt durch Rückmeldung auf ABK*/ || ' ' || rec.a2_ab_ix::VARCHAR || ' AG ' || rec.a2_n::VARCHAR
   );

   IF COALESCE(rec.FixPreis,0) > 0 THEN --Fixpreis aus Stammkarte, etwa für Programmierkosten oder ähnliches. Als separate Position oder Ab- / Zuschlag
     INSERT INTO belegabzu ( belaz_belegtyp, belaz_dokument_id, belaz_abzu_id ,belaz_betrag, belaz_anzahl, belaz_steucode, belaz_steuproz, belaz_ks_abt, belaz_zutxt)
       SELECT 'ERG', docRec.beld_id, 300, rec.fixpreis, 1, rec.steucode, rec.steuproz,rec.ks, lang_text(29198) /*'Automatisch erstellt durch Rückmeldung auf ABK*/ || ' '  || rec.a2_ab_ix::VARCHAR || ' AG ' || rec.a2_n::VARCHAR
                   WHERE NOT EXISTS(SELECT true FROM belegabzu WHERE belaz_dokument_id = docRec.beld_id AND belaz_abzu_id=300);
   END IF;

   RETURN  posid;
 END $$ LANGUAGE plpgsql VOLATILE;




/****************************Aktualisieren der fakturierten Mengen in Vorgängerbelegen****************************/

CREATE OR REPLACE FUNCTION TBeleg.update_ldsdokStkf(
      _ldid integer
  ) RETURNS void AS $$
  DECLARE
      _stkf numeric;
      _ldsdok_record ldsdok;
      _rechnungs_eingang bool;
  BEGIN

      IF _ldid IS NULL THEN
          RETURN;
      END IF;

      -- abgerechnete stückzahl geliefert
      _stkf :=
        round( sum( belp_menge_gme ), 2 )
        FROM eingrech_pos
        WHERE belp_ld_id = _ldid
        AND belp_belegtyp = 'ERG'
      ;

      _stkf := coalesce( _stkf, 0 );

      _ldsdok_record := ldsdok FROM ldsdok WHERE ld_id = _ldid;

      -- alten status behalten, wenn _stkf > 0 aber kleiner ld_stk_uf1 ist.
      _rechnungs_eingang := _ldsdok_record.ld_rech_eing;

      -- wenn mehr geliefert als bestellt
      IF _stkf >= round( _ldsdok_record.ld_stk_uf1, 2 ) THEN
          _rechnungs_eingang := true;
      ELSEIF _stkf = 0 THEN
          _rechnungs_eingang := false;
      END IF;

      PERFORM disablemodified();
      UPDATE ldsdok SET
        ld_stkf = _stkf,
        ld_rech_eing = _rechnungs_eingang
        WHERE ld_id = _ldid
      ;
      PERFORM enablemodified();

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION TBeleg.Update_WendatStkf(IN wwen INTEGER) RETURNS VOID AS $$
 DECLARE stkf NUMERIC;
 BEGIN
   IF wwen IS NULL THEN
     RETURN;
   END IF;
   PERFORM disablemodified();

   SELECT Round( COALESCE(SUM (belp_menge_gme),0),2) INTO stkf FROM eingrech_pos WHERE belp_w_wen = wwen;

   UPDATE wendat SET w_stkf = stkf,
                     w_rech_eing = IfThen( (stkf >= Round(w_zugang_uf1,2)),
                                            True,
                                            IfThen((stkf = 0),FALSE,w_rech_eing))
          WHERE w_wen = wwen;
   PERFORM enablemodified();
 END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TBeleg.LFS_Update_Auftg(IN agnr VARCHAR, IN agpos INTEGER) RETURNS VOID AS $$ /*TWawi*/
  DECLARE agid INTEGER;
  BEGIN
    SELECT ag_id INTO agid FROM auftg WHERE ag_astat = 'E' AND ag_nr = agnr AND ag_pos = agpos;
    PERFORM TBeleg.LFS_Update_Auftg(agid);
    RETURN;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TBeleg.LFS_Update_Auftg(IN agid INTEGER) RETURNS VOID AS $$ /*TWawi*/
  DECLARE stkllifsch           NUMERIC(12,4);
          stklbelpos           NUMERIC(12,4);
          stkfbelzeil          NUMERIC(12,4);
  BEGIN
    IF agid IS NULL THEN
        RETURN;
    END IF;

    -- Summe der Lagerabgänge für den Auftrag.
    SELECT COALESCE( SUM(COALESCE(l_abgg_uf1, 0)),0) INTO stkllifsch
      FROM lifsch WHERE l_ag_id = agid AND l_bz_id IS NULL; -- LA sind aus Auftrag und keiner Rechnung (auf Konsi-LFS) zugeordnet, siehe #8093.

    -- Summe die direkt aus Auftrag in Lieferscheindokument übernommen wurde. Es darf also keinen Lagerabgang auf den Auftrags geben.
    SELECT COALESCE( SUM(COALESCE(IFTHEN(beld_belegart = 10, -1, 1) * belp_menge_gme, 0)),0) INTO stklbelpos -- beld_belegart = 10 Stornolieferscheine, Minus-Menge
      FROM belegpos
        JOIN belegdokument ON beld_id = belp_dokument_id
      WHERE belp_ag_id = agid AND belp_belegtyp = 'LFS'
        -- wenn richtiger Lagerabgang, dann wird von Trigger lifsch aus ag_stkl bereits berechnet und gesetzt. Daher darf das hier nicht nochmal, oder es müßte dort entfernt werden!
        AND NOT EXISTS (SELECT true FROM lifsch WHERE l_belp_id = belp_id);

    /* Alte Version (vor 10/2017) - Da gab es unter ganz bestimmten Umständen ein Reihenfolgeproblem beim Rahmenabruf. => http://redmine.prodat-sql.de/issues/8277
       SELECT SUM(COALESCE(belp_menge_gme, 0)) INTO stklbelpos FROM belegpos LEFT JOIN lifsch ON l_belp_id = belp_id WHERE belp_ag_id = agid AND belp_belegtyp = 'LFS' AND l_ag_id IS NULL;
    */

    -- Verrechnete Menge aus Faktura in Schlussrechnungen
    SELECT SUM(COALESCE(bz_fakt_uf1-COALESCE(gutschriften.fakt_uf1, 0), 0)) INTO stkfbelzeil
      FROM belzeil_auftg_lif
        JOIN belkopf ON bz_be_bnr = be_bnr
        JOIN auftg ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos,
        LATERAL ( -- fakturierte Menge der Gutschriften. Wird abgezogen.
            SELECT SUM(COALESCE(bg_g.bz_fakt_uf1, 0)) AS fakt_uf1
            FROM belzeil_grund AS bg_g
              JOIN belkopf AS bk_g ON bk_g.be_bnr = bg_g.bz_be_bnr
            WHERE bk_g.be_prof = 'G'
              AND bg_g.bz_bz_be_bnr = belzeil_auftg_lif.bz_be_bnr
              AND bg_g.bz_bz_pos = belzeil_auftg_lif.bz_pos
              AND (be_txba <> 12) -- Rechnungskorrektur korrigiert den LFS NICHT
            ) AS gutschriften
      WHERE be_prof = 'R'
        AND ag_id = agid;
    -- Liefermenge, fakturierte Menge und Auftrag in Auftrag zurückschreiben
    PERFORM disablemodified();
    PERFORM execution_code__disable( _flagname => 'auftg' );
    UPDATE auftg SET
        ag_stkl = COALESCE(stkllifsch, 0) + COALESCE(stklbelpos, 0),
        ag_stkf = COALESCE(stkfbelzeil, 0),
        ag_done = IFTHEN(COALESCE(stkllifsch, 0) + COALESCE(stklbelpos, 0) = 0, ag_stk <= COALESCE(stkfbelzeil, 0), ag_done)
        -- Rechnungsposition ohne Lieferschein löschen soll auch den Auftrag wieder öffnen (Auftrag ohne Lieferschein direkt in Rechnung)
        -- Wenn nichts in Lieferschein, dann Prüfen ob alles verrechnet. Sonst so lassen, wie es war.
    WHERE ag_id = agid;
    PERFORM execution_code__enable( _flagname => 'auftg' );
    PERFORM enablemodified();

    RETURN;
  END $$ LANGUAGE plpgsql;
--

--- #9393 Assistent - SQL
CREATE OR REPLACE FUNCTION tbeleg.Assistent_RE_LFS_Auftg_geschlossen(IN _belp_id INTEGER, OUT ag_geschlossen BOOLEAN, OUT lfs_geschlossen BOOLEAN) RETURNS RECORD AS $$
  BEGIN
    --- Auftrag
    SELECT ag_done INTO ag_geschlossen
    FROM auftg
    WHERE ag_nr IN (SELECT ag_nr FROM lieferschein_pos  JOIN auftg ON ag_id = belp_ag_id AND ag_astat = 'E' WHERE belp_id = _belp_id)
    ORDER BY ag_done LIMIT 1;
    IF ag_geschlossen IS NULL THEN
       ag_geschlossen := false;
    END IF;

    --- LFS
    SELECT ag_done INTO lfs_geschlossen
    FROM lieferschein_pos
      JOIN auftg ON ag_id = belp_ag_id AND ag_astat = 'E'
    WHERE belp_dokument_id = (SELECT belp_dokument_id FROM belegpos WHERE belp_id = _belp_id)
    ORDER BY ag_done LIMIT 1;
    IF lfs_geschlossen IS NULL THEN
       lfs_geschlossen := false;
    END IF;

    RETURN;
 END $$ LANGUAGE plpgsql STABLE;



/* (LG,12/2013) Entfällt, Liefermengen nur noch im Auftrag, Verwaltung im Lagerabgang über l_belp_id
CREATE OR REPLACE FUNCTION TBeleg.LFS_Update_Lifsch(IN lnr INTEGER) RETURNS VOID ... */


--

-- Positionswert einer Belegposition mit Parametern, was einzurechnen ist
CREATE OR REPLACE FUNCTION TBeleg.PosWert (IN pos     Belegpos,
                                           IN Brutto  BOOLEAN DEFAULT TRUE,
                                           IN Basisw  BOOLEAN DEFAULT TRUE,
                                           IN Rabatt  BOOLEAN DEFAULT TRUE,
                                           IN MitAbzu BOOLEAN DEFAULT TRUE )
                                          RETURNS NUMERIC(12,4)  AS $$
 DECLARE wert NUMERIC;
        rec  RECORD;
 BEGIN

  -- Preis in  Belegwährung als Ausgangsbasis
  wert := pos.belp_preis_gme * pos.belp_menge_gme;

  -- Rabatt abziehen, wenn rabattfaehig
  wert := wert * IfThen( Rabatt AND pos.belp_rabattfaehig, (1 - pos.belp_rabatt / 100), 1);

  -- Steuern draufrechnen
  wert := wert * (1 + IfThen(Brutto, pos.belp_steuproz,0) / 100);

  -- In Eigenwährung umrechnen
  wert := wert * IfThen(BasisW, pos.belp_kurs,1);

  -- Brutto- oder Nettosumme der Abzuschläge aufrechnen
  IF MitAbzu THEN
    wert := wert + TBeleg.AbzuWert(pos, Brutto, BasisW,Rabatt);
  END IF;

  RETURN COALESCE(wert, 0) :: NUMERIC(12,4);
 END $$ LANGUAGE plpgsql STABLE;
--

-- Summierte Wert der dokumentbezogenen Zuschläge
CREATE OR REPLACE FUNCTION TBeleg.AbzuWert(IN dok     BelegDokument,
                                           IN Brutto  BOOLEAN DEFAULT TRUE,
                                           IN Basisw  BOOLEAN DEFAULT TRUE,
                                           IN Rabatt  BOOLEAN DEFAULT TRUE)
                                          RETURNS NUMERIC(12,4)  AS $$
 DECLARE wert  NUMERIC;
        summe NUMERIC;
        kurs  NUMERIC;
        rec   RECORD;
 BEGIN

  summe := 0;
  IF (Basisw) THEN -- Kurs aus letzter Position für Belegabzuschlaege bei Fremdwaehrung (analog GetDokumentSumme)
    SELECT COALESCE(belp_kurs, 1) INTO kurs FROM belegpos WHERE belp_dokument_id = dok.beld_id ORDER BY belp_pos DESC LIMIT 1;
  END IF;

  FOR rec IN SELECT * FROM belegabzu WHERE belaz_dokument_id = dok.beld_id LOOP
    wert := COALESCE(rec.belaz_betrag, 0) * COALESCE(rec.belaz_anzahl, 0);
    wert := wert * IfThen (Rabatt AND rec.belaz_canrabatt, (1 - dok.beld_gesamtrabatt / 100), 1);
    wert := wert * (1 + IfThen(Brutto, rec.belaz_steuproz,0) / 100);
    wert := wert * IfThen(BasisW, kurs, 1);
    Summe := summe + wert;
  END LOOP;

  RETURN COALESCE(summe, 0) :: NUMERIC(12,4);
 END $$ LANGUAGE plpgsql STABLE;
--

-- Summierte Wert der positionsbezogenen Zuschläge
CREATE OR REPLACE FUNCTION TBeleg.AbzuWert(IN pos     Belegpos,
                                           IN Brutto  BOOLEAN DEFAULT TRUE,
                                           IN Basisw  BOOLEAN DEFAULT TRUE,
                                           IN Rabatt  BOOLEAN DEFAULT TRUE)
                                          RETURNS NUMERIC(12,4)  AS $$
 DECLARE wert  NUMERIC;
        summe NUMERIC;
        rec   RECORD;
 BEGIN

  summe := 0;
  FOR rec IN SELECT * FROM belegposabzu WHERE belpaz_belegpos_id = pos.belp_id LOOP
    wert := COALESCE(rec.belpaz_betrag, 0) * COALESCE(rec.belpaz_anzahl, 0);
    wert := wert * IfThen (Rabatt AND rec.belpaz_canrabatt, (1 - pos.belp_rabatt / 100), 1);
    wert := wert * (1 + IfThen(Brutto, rec.belpaz_steuproz,0) / 100);
    wert := wert * IfThen(BasisW, pos.belp_kurs,1);
    Summe := summe + wert;
  END LOOP;

  RETURN COALESCE(summe, 0) :: NUMERIC(12,4);
 END $$ LANGUAGE plpgsql STABLE;
--

-- Wert eines dokumentbezogenen Zuschlags
CREATE OR REPLACE FUNCTION TBeleg.AbzuWert(IN az      BelegAbzu,
                                           IN Brutto  BOOLEAN DEFAULT TRUE,
                                           IN Basisw  BOOLEAN DEFAULT TRUE,
                                           IN Rabatt  BOOLEAN DEFAULT TRUE)
                                          RETURNS NUMERIC(12,4)  AS $$
 DECLARE wert  NUMERIC;
        kurs  NUMERIC;
        rec   RECORD;
 BEGIN

  SELECT * INTO rec FROM belegdokument WHERE az.belaz_dokument_id = beld_id;
  IF (Basisw) THEN -- Kurs aus letzter Position für Belegabzuschlaege bei Fremdwaehrung (analog GetDokumentSumme)
    SELECT COALESCE(belp_kurs, 1) INTO kurs FROM belegpos WHERE belp_dokument_id = rec.beld_id ORDER BY belp_pos DESC LIMIT 1;
  END IF;

  wert := COALESCE(az.belaz_betrag, 0) * COALESCE(az.belaz_anzahl, 0);
  wert := wert * IfThen (Rabatt AND az.belaz_canrabatt, (1 - rec.beld_gesamtrabatt / 100), 1);
  wert := wert * (1 + IfThen(Brutto, az.belaz_steuproz,0) / 100);
  wert := wert * IfThen(BasisW, kurs, 1);

  RETURN COALESCE(wert, 0) :: NUMERIC(12,4);
 END $$ LANGUAGE plpgsql STABLE;
--

-- Wert eines positionsbezogenen Zuschlags
CREATE OR REPLACE FUNCTION TBeleg.AbzuWert(IN az      BelegPosAbzu,
                                           IN Brutto  BOOLEAN DEFAULT TRUE,
                                           IN Basisw  BOOLEAN DEFAULT TRUE,
                                           IN Rabatt  BOOLEAN DEFAULT TRUE)
                                          RETURNS NUMERIC(12,4)  AS $$
 DECLARE wert  NUMERIC;
         rec   RECORD;
 BEGIN

  SELECT * INTO rec FROM belegpos WHERE az.belpaz_belegpos_id = belp_id;
  wert := COALESCE(az.belpaz_betrag, 0) * COALESCE(az.belpaz_anzahl, 0);
  wert := wert * IfThen (Rabatt AND az.belpaz_canrabatt, (1 - rec.belp_rabatt / 100), 1);
  wert := wert * (1 + IfThen(Brutto, az.belpaz_steuproz,0) / 100);
  wert := wert * IfThen(BasisW, rec.belp_kurs,1);

  RETURN COALESCE(wert, 0) :: NUMERIC(12,4);
 END $$ LANGUAGE plpgsql STABLE;
--

-- Prüft ob die wichtigsten Vorbedingungen erfüllt sind, damit die Rechnung in die Buchhaltung kann.
CREATE OR REPLACE FUNCTION TBeleg.ExportReady(
    IN  _dok Belegdokument,
    IN  _buchungskonto varchar,
    IN  _export_type varchar = null,
    OUT IsValid boolean,
    OUT ErrorString text
    )
    RETURNS record
    AS $$
    DECLARE
      _r record;
      _firstpos_kto varchar;
      _firstpos_ks varchar;
    BEGIN

      IsValid := true;
      _export_type := coalesce(_export_type, '');

      IF NOT _dok.beld_definitiv THEN
        IsValid := false;
        ErrorString := TSystem.FormatLines(ErrorString, lang_text(13625)); -- Nicht definitiv
      END IF;

      IF coalesce(trim(_dok.beld_refbeleg),'') = '' THEN
        IsValid := false;
        ErrorString := TSystem.FormatLines(ErrorString, lang_text(13628)); -- Rechnungsnummer des Lieferant fehlt.
      END IF;

       --Kurs aus erster Position für Belegabzuschlaege bei Fremdwaehrung (analog GetDokumentSumme, GetKontenAufteilung)
      SELECT /*coalesce(belp_kurs, 1), */ belp_konto, belp_kostenstelle
        INTO /*_kurs,*/ _firstpos_kto, _firstpos_ks
        FROM belegpos
       WHERE belp_dokument_id = _dok.beld_id
       ORDER BY belp_pos
         ASC LIMIT 1;

      -- Prüfung Buchungskonten
      -- Aus Performancegründen wird der LATERAL JOIN nur gemacht, wenn das _Buchungskonto hereingereicht wird.
      IF _buchungskonto IS null THEN
        SELECT a2_knr, coalesce( aufteilung.konto, a2_veco ) AS a2_veco INTO _r
          FROM adressen_view
          JOIN adk2 ON a2_krz = adk_ad_krz
          LEFT JOIN LATERAL (SELECT * FROM TBeleg.GetKontenAufteilung( _dok.beld_id )) AS aufteilung ON true
         WHERE adk_ad_krz = _dok.beld_krzrechnung;
      ELSE
        SELECT a2_knr, _buchungskonto AS a2_veco INTO _r
          FROM adressen_view
          JOIN adk2 ON a2_krz = adk_ad_krz
         WHERE adk_ad_krz = _dok.beld_krzrechnung;
      END IF;

      IF NOT coalesce( _r.a2_knr > 0, false ) THEN
        IsValid := false;
        ErrorString := TSystem.FormatLines(ErrorString, lang_text(10654), 'a2_knr = 0'); -- Keine Kreditorendaten gefunden
      END IF;

      IF ( _export_type ILIKE 'SESAM' ) AND NOT coalesce( _r.a2_veco > 0, false ) THEN
        IsValid := false;
        ErrorString := TSystem.FormatLines(ErrorString, lang_text(28731), 'a2_veco = 0'); -- Buchungskonto nicht gefunden
      END IF;


      --Kontierung und Steuercode prüfen
       FOR _r IN SELECT belp_pos                      AS sortID,
                        belp_konto                    AS konto,
                        belp_steucode                 AS steucode,
                        lang_text(15247) || belp_pos  AS ident
                   FROM belegpos
                  WHERE belp_dokument_id = _dok.beld_id
                  UNION
                 SELECT 100002,
                        coalesce(belaz_konto, steu_konto, steu_konto, _firstpos_kto),
                        belaz_steucode,
                        abz_txt
                   FROM belegabzu
                   JOIN abzu ON belaz_abzu_id = abz_id
                   LEFT JOIN steutxt ON steu_z = belaz_steucode
                  WHERE belaz_dokument_id = _dok.beld_id
                  UNION
                 SELECT 100003,
                        coalesce(belpaz_konto, belp_konto, steu_konto, _firstpos_kto),
                        belpaz_steucode,
                        abz_txt -- Kontierung der zugeordneten Position!
                   FROM belegposabzu
                   JOIN belegpos ON belpaz_belegpos_id = belp_id
                   JOIN abzu ON belpaz_abzu_id = abz_id
                   LEFT JOIN steutxt  ON steu_z = belpaz_steucode
                  WHERE belp_dokument_id = _dok.beld_id
                  ORDER BY sortID, ident
       LOOP
          IF _r.konto IS NULL THEN
            IsValid := false;
            ErrorString := TSystem.FormatLines(ErrorString, _r.Ident ||': ' || lang_text(13626)); -- Kontierung fehlt
          END IF;
          IF _r.steucode IS NULL THEN
            IsValid := false;
            ErrorString := TSystem.FormatLines(ErrorString, _r.Ident ||': ' || lang_text(13627)); -- Steuercode fehlt
          END IF;
       END LOOP;

      RETURN;

    END $$ LANGUAGE plpgsql STABLE;
--

/*
SELECT TBeleg.PosWert (belegpos     , true, true, true, true) FROM belegpos;
SELECT TBeleg.AbzuWert(belegdokument, true, true, true), *    FROM belegdokument ORDER BY beld_id DESC;
SELECT TBeleg.AbzuWert(belegpos     , true, true, true), *    FROM belegpos;
SELECT TBeleg.AbzuWert(belegabzu    , true, true, true), *    FROM belegabzu;
SELECT TBeleg.AbzuWert(belegposabzu , true, true, true), *    FROM belegposabzu;
*/



/*******************************************************************************************
NEUER LIEFERSCHEIN (AB Delphi XE-Umstellung)
*******************************************************************************************/

CREATE OR REPLACE FUNCTION TBeleg.LieferscheinStatus(IN beldok INTEGER) RETURNS VARCHAR AS $$
 DECLARE rec RECORD;
         result VARCHAR(40);
 BEGIN

   SELECT * INTO rec FROM lieferschein WHERE beld_id = beldok;

   result:=IfThen( rec.beld_definitiv, lang_text(10935),''); -- "Definitiv"

   IF result <> '' THEN
     result:=result || IfThen( rec.beld_freigabe, ' | ' || lang_text(12058), '' ); -- "Gedruckt"
   ELSE
     result:=result || IfThen( rec.beld_freigabe, lang_text(12058), '' ); -- "Gedruckt"
   END IF;

   IF result <> '' THEN
     result:=result || IfThen( rec.beld_verbucht, ' | ' || lang_text(12059), '' ); -- "Verbucht"
   ELSE
     result:=result || IfThen( rec.beld_verbucht, lang_text(12059), '' ); -- "Verbucht"
   END IF;

   RETURN COALESCE(result,'');
 END $$ LANGUAGE plpgsql STABLE;


/****************************Lieferscheindokument aus Lagerabgang*****************************/
CREATE OR REPLACE FUNCTION TBeleg.LiefDokFromLagAb(IN lifschdbrid VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$ /*TWawi*/
 DECLARE
   rec     RECORD;
   docRec  RECORD;
   frei    BOOLEAN;
   belegid INTEGER;
   docid   INTEGER;
   versart VARCHAR;

 BEGIN

  SELECT beld_id INTO docid FROM lieferschein WHERE beld_dokunr = belegdoknr;

  -- Belegdokument noch anlegen? Falls es das schon gibt, haengen wir Positionen an.
  IF NOT (docid IS NULL) THEN
    RETURN docid;
  END IF;

  --Gibt es Auftrag zum Lieferschein oder war das vielleicht freier Lagerabgang?
  SELECT (l_ag_id IS NULL) INTO frei FROM lifsch WHERE lifsch.dbrid = lifschdbrid;

  -- Wir sammeln mal alle möglichen Daten im System
  SELECT COALESCE(l_versart,atd_vers,a1_vers) AS versart,
         COALESCE(
                (SELECT v_id FROM versart WHERE v_art = TRIM(l_versart)),
                atd_v_id,
                (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))
                ) as versartID,
         l_abgg, ag_id, l_krz, l_krzl, l_krzf, atd_ld_auftg, l_ag_id, l_ldat,l_kdat , l_akdat,
         l_an_nr, atd_apkrzl, atd_ap, atd_apint, atd_versandort
      INTO rec
         FROM lifsch    LEFT JOIN adk1 ON a1_krz = l_krz    -- <= Bestelleradresse gibt Versandart vor.
                        LEFT JOIN auftg ON ag_id = l_ag_id
                        LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
         WHERE lifsch.dbrid = lifschdbrid;

  -- Belegdokument anlegen
  INSERT INTO belegdokument (
      beld_belegtyp, beld_dokunr, beld_apkrzl, beld_ap, beld_zak, beld_skv, beld_sks, beld_versandart, beld_versandartbem,
      beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_waehr, beld_erstelldatum, beld_refbeleg
      , beld_versandort, beld_apint
  ) VALUES (
      'LFS', belegdoknr, rec.atd_apkrzl, rec.atd_ap, 0, 0, 0, rec.versartID, rec.versart,
      rec.l_krz, rec.l_krzl, rec.l_krzf, TSystem.Settings__Get('BASIS_W'), current_date, rec.atd_ld_auftg --527="Lieferschein"
      , rec.atd_versandort, ifthen( Settings__GetBool( 'belegdokument__apint__from__auftg' ), rec.atd_apint, current_user::varchar )
  );

  SELECT beld_id INTO docid FROM lieferschein WHERE beld_dokunr = belegdoknr;

  RETURN docid;
 END $$ LANGUAGE plpgsql VOLATILE;


-- //****************************Lieferscheindokument aus Auftrag*****************************/
CREATE OR REPLACE FUNCTION TBeleg.LiefDokFromAuftg(IN auftgdbrid VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$ /*TWawi*/
 DECLARE rec     RECORD;
     docRec     RECORD;
       frei     BOOLEAN;
      belegid   INTEGER;
        docid   INTEGER;
       versart  VARCHAR;
 BEGIN

  SELECT beld_id INTO docid FROM lieferschein WHERE beld_dokunr = belegdoknr;

  -- Belegdokument noch anlegen? Falls es das schon gibt, haengen wir Positionen an.
  IF NOT (docid IS NULL) THEN
    RETURN docid;
  END IF;

  --Gibt es Auftrag zum Lieferschein oder war das vielleicht freier Lagerabgang?
  --SELECT (l_ag_id IS NULL) INTO frei FROM lifsch WHERE lifsch.dbrid = lifschdbrid;

  -- Wir sammeln mal alle möglichen Daten im System
  SELECT COALESCE(atd_vers,a1_vers) AS versart,
         COALESCE(atd_v_id, (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))) as versartID,
         ag_stk, ag_id, ag_lkn, ag_krzl, ag_krzf, atd_ld_auftg, ag_kdatum, ag_ldatum, ag_datum,
         ag_an_nr, atd_apkrzl, atd_ap, atd_apint, atd_versandort
      INTO rec
         FROM auftg     LEFT JOIN adk1 ON a1_krz = ag_lkn    -- <= Bestelleradresse gibt Versandart vor.
                        LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
         WHERE auftg.dbrid = auftgdbrid;

  -- Belegdokument anlegen
  INSERT INTO belegdokument (
      beld_belegtyp, beld_dokunr, beld_apkrzl, beld_ap, beld_zak, beld_skv, beld_sks, beld_versandart, beld_versandartbem,
      beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_waehr, beld_erstelldatum, beld_refbeleg
      , beld_versandort, beld_apint
  ) VALUES (
      'LFS', belegdoknr, rec.atd_apkrzl, rec.atd_ap, 0, 0, 0, rec.versartID, rec.versart,
      rec.ag_lkn, rec.ag_krzl, rec.ag_krzf, TSystem.Settings__Get('BASIS_W'), current_date, rec.atd_ld_auftg --527="Lieferschein"
      , rec.atd_versandort, ifthen( Settings__GetBool( 'belegdokument__apint__from__auftg' ), rec.atd_apint, current_user::varchar )
  );

  SELECT beld_id INTO docid FROM lieferschein WHERE beld_dokunr = belegdoknr;

  RETURN docid;
 END $$ LANGUAGE plpgsql VOLATILE;
--

-- //*************************** Lieferscheinposition aus Lagerabgang ****************************/
CREATE OR REPLACE FUNCTION TBeleg.LiefPosFromLagAb(
      _lifschdbrid  varchar,
      _belegdoknr   varchar,
      _menge        numeric
  ) RETURNS integer AS $$     /*TWawi*/ -- ?
  DECLARE
      _rec                      record;
      _docRec                   record;
      _frei                     boolean;
      _addLiefPosID             integer;
      _belegid                  integer;
      _posid                    integer;
      _verrechenbar             boolean;
      _beistellung              boolean;
      _konsignation             boolean := false; -- Ist ein  Konsignationsprozess.
      _MergeLagAbg              boolean := false; -- Wir dürfen Lagerangänge des gleichen Artikel auf die gleiche
                                                  -- Auftragsposition als 1 Lieferscheinposition zusammenfassen.
      _MergeLagAbg_CheckChnr    boolean := false; -- ... (nur) wenn die Chargennummer übereinstimmt.
      _MergeLagAbg_CheckLgOrtUE boolean := false; -- ... (nur) wenn sie auf dem gleichen Kommissionierlagerort liegen.
  BEGIN

      -- Wir sammeln mal alle möglichen Daten im System.
        -- aus Lagerabgang, Artikel, Debitorendaten, Auftrag
      SELECT
        ag_akbz AS akbez,

        -- Versandart holen.
        coalesce( l_versart, atd_vers, a1_vers )
        AS versart,

        -- Versandart-ID (v_id) dazu finden.
        coalesce(
            -- v_id entspr. Lagerabgang
            (
                SELECT v_id
                FROM versart
                WHERE v_art = trim( l_versart )
            ),

            -- v_id entspr. Auftrag
            atd_v_id,

            -- v_id entspr. Debitorendaten
            (
                SELECT v_id
                FROM versart
                WHERE v_art = trim( a1_vers )
            )
        )
        AS versartID,

        coalesce( l_abgg, 0 ) AS l_abgg,
        l_abg_mec,
        l_krz,
        l_krzl,
        l_krzf,
        l_abgg_uf1,
        l_aknr,
        l_ag_id,
        l_an_nr,
        l_ldat,
        l_kdat,
        l_akdat,
        l_bda,

        -- Bemerkungstext ggf. aus Auftrag
        ifthen(
            TSystem.Settings__GetBool( 'lifsch_dont_use_auftgtxt' ),
            l_azutx,
            coalesce( l_azutx, ag_txt )
        )
        AS l_azutx,

        -- Bemerkungstext (rtf) ggf. aus Auftrag
        ifthen(
            TSystem.Settings__GetBool( 'lifsch_dont_use_auftgtxt' ),
            l_azutx_rtf,
            coalesce( l_azutx_rtf, ag_txt_rtf )
        )
        AS l_azutx_rtf,

        ag_postxt,
        ag_postxt_rtf,
        TSystem.Settings__Get( 'BASIS_W' ) AS waer,
        l_nr,
        m_uf,
        l_lgchnr,
        l_dofakt,
        l_lgort_ue,
        ag_bstat,
        ag_bstat1,
        ag_bstat2, -- #7895
        ag_stat,
        ak_gewicht
      FROM lifsch
        JOIN artmgc ON l_abg_mec = m_id
        JOIN art ON ak_nr = l_aknr
        LEFT JOIN adk1 ON a1_krz = l_krz
        LEFT JOIN auftg ON ag_id = l_ag_id
        LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
      WHERE lifsch.dbrid = _lifschdbrid
      INTO
        _rec
      ;


      -- ist Konsignationsprozess anhand Auftragsstatus
      _konsignation :=
              TSystem.Enum_GetValue( _rec.ag_bstat,  'K' )
          OR  TSystem.Enum_GetValue( _rec.ag_bstat1, 'K' )
          OR  TSystem.Enum_GetValue( _rec.ag_bstat2, 'K' )
      ;

      -- Wenn Konsignationsprozess, dann kein Zusammenführen von LA
        -- #10425: Ein Zusammenführen der LA führt zu Problemen,
        -- da belzeil_auftg_lif__a_60_iu__ _konsignationslager nicht mehrere LAs aufteilen kann.
      IF _konsignation THEN

          _MergeLagAbg := false;

      -- wenn kein Konsignationsprozess, dann so wie üblich.
      ELSE

          _MergeLagAbg := TSystem.Settings__GetBool( 'MergeLagAbg' );

      END IF;


      -- Wenn LA-Zusammenführung der gleichen Auftragsnummer, Konfig dazu ermitteln.
      IF _MergeLagAbg THEN

          -- nur gleiche Chargennummern zusammenführen
          _MergeLagAbg_CheckChnr    := TSystem.Settings__GetBool( 'MergeLagAbg_CheckChnr' );

          -- nur gleichen Kommissionslagerort zusammenführen
          _MergeLagAbg_CheckLgOrtUE := TSystem.Settings__GetBool( 'MergeLagAbg_CheckLgOrtUE' );

      END IF;


      -- Lieferschein-Infos
      SELECT
        beld_id,
        beld_belegtyp
      FROM lieferschein
      WHERE beld_dokunr = _belegdoknr
      INTO
        _docRec
      ;

      -- Beleg-ID
      SELECT
        bel_id
      FROM beleg
      WHERE bel_belegtyp = _docRec.beld_belegtyp
        AND bel_nummer = _belegdoknr
      INTO
        _belegid
      ;


      -- Freier Lieferschein: Satz gefunden, aber kein Auftrag für Lagerabgang?
      _frei :=
              _rec.l_nr IS NOT NULL
          AND _rec.l_ag_id IS NULL
      ;

      -- Beistellung an Lieferant oder durch Kunde?
      _beistellung :=
              TSystem.Enum_GetValue( _rec.ag_stat, 'BL' )
          OR  TSystem.Enum_GetValue( _rec.ag_stat, 'BK' )
      ;

      -- Die Lieferscheinposition ist verrechenbar, wenn Lagerabgang noch nicht verrechnet ist und es keine Beistellung ist
      _verrechenbar :=
              _rec.l_dofakt
          AND NOT _beistellung
      ;

      -- Prüfen ob wir den Lagerabgang mit Anderen zu einer Lieferscheinpos. zusammenfassen dürfen / könnten
      _addLiefPosID := null;

      IF
              NOT _frei
          AND _MergeLagAbg

      THEN

          -- Lieferscheinposition ermitteln
          SELECT
            belp_id
          FROM lieferschein_pos
            JOIN lieferschein ON belp_dokument_id = beld_id
            JOIN lifsch ON belp_id = l_belp_id
          WHERE
                belp_ag_id    = _rec.l_ag_id    -- auf gleiche Auftragsposition
            AND belp_aknr     = _rec.l_aknr     -- mit gleichem Artikel
            AND beld_dokunr   = _belegdoknr     -- auf dem Lieferschein auf den wir übernehmen sollen
            AND belp_mce      = _rec.l_abg_mec  -- in der gleichen Mengeneinheit
            AND NOT belp_storniert              -- weder storniert
            AND NOT belp_erledigt               -- noch fakturiert

            -- ggf. auf gleichem Lagerort kommissioniert
            AND (
                    NOT _MergeLagAbg_CheckLgOrtUE
                OR  coalesce( l_lgort_ue, '' ) = coalesce( _rec.l_lgort_ue, '' )
            )

            -- ggf. die gleiche Chargen-Nummer haben
            AND (
                    NOT _MergeLagAbg_CheckChnr
                OR coalesce( l_lgchnr, '' ) = coalesce( _rec.l_lgchnr, '' )
            )

          INTO
            _addLiefPosID
          ;

      END IF;


      -- Fehler bei abweichenden Mengen
      IF round( _menge, 4 ) <> round( _rec.l_abgg, 4 ) THEN
          RAISE EXCEPTION 'TBeleg.LiefPosFromLagAb: % % ', lang_text( 13198 ), _rec.l_nr;
      END IF;


      -- Nicht zusammenfassen
      IF _addLiefPosID IS NULL THEN

          SELECT nextval( 'belegpos_belp_id_seq' ) INTO _posid;

          PERFORM TSystem.execution_code__disable('belegpos__a_50_iud.LFS_Update_Auftg');

          -- Belegposition anlegen
          INSERT INTO belegpos (
              belp_id          , belp_belegtyp     , belp_dokument_id , belp_beleg_id     , belp_ag_id,
              belp_waehr       , belp_aknr         , belp_akbez       , belp_mce          , belp_projektnummer,
              belp_versandart  , belp_versandartbem, belp_krzbesteller, belp_krzlieferung , belp_krzrechnung,
              belp_referenz    , belp_menge        , belp_preiseinheit, belp_dokutxt      , belp_dokutxt_rtf,
              belp_storniert   , belp_erstelldatum , belp_termin      , belp_txt          , belp_txt_rtf,
              belp_bstat       , belp_bstat1       , belp_bstat2      , belp_gewicht
            )
          VALUES (
              _posid           , 'LFS'             , _docRec.beld_id  , _belegid          , _rec.l_ag_id,
              _rec.waer        , _rec.l_aknr       , _rec.akbez       , _rec.l_abg_mec    , _rec.l_an_nr,
              _rec.versartID   , _rec.versart      , _rec.l_krz       , _rec.l_krzl       , _rec.l_krzf,
              _rec.l_bda       , _rec.l_abgg       , 1                , _rec.l_azutx      , _rec.l_azutx_rtf,
              NOT _verrechenbar, _rec.l_ldat       , _rec.l_akdat     , _rec.ag_postxt    , _rec.ag_postxt_rtf,
              _rec.ag_bstat    , _rec.ag_bstat1    , _rec.ag_bstat2   , ( _rec.ak_gewicht * _rec.l_abgg_uf1 )
            )
          ;

          -- Belegposition in lifsch zurückschreiben
          UPDATE lifsch SET
            l_belp_id = _posid,
            l_inliefdok = true
          WHERE l_nr =_rec.l_nr
          ;

          PERFORM TSystem.execution_code__enable('belegpos__a_50_iud.LFS_Update_Auftg');

          PERFORM TBeleg.LFS_Update_Auftg( _rec.l_ag_id );

      -- Lagerabgänge zusammenfassen zu einer Lieferscheinposition
      ELSE

          -- Menge aufaddieren und Gewicht aktualisieren
          UPDATE belegpos SET
            belp_menge = belp_menge + _rec.l_abgg,
            belp_gewicht = ( _rec.ak_gewicht * ( belp_menge_gme + _rec.l_abgg_uf1 ) )
          WHERE belp_id = _addLiefPosID
          ;

          -- Belegposition in lifsch zurückschreiben
          UPDATE lifsch SET
            l_belp_id = _addLiefPosID,
            l_inliefdok = true
          WHERE l_nr = _rec.l_nr
          ;

      END IF;


      -- Wenn die Position aus Lagerabgang eines Beistellmaterials stammt und das die erste Position ist,
      -- markieren wir den Lieferschein entsprechend.
      IF _beistellung THEN

          UPDATE belegdokument SET
            beld_belegart = 6
          WHERE
                beld_id = _docRec.beld_id
            AND beld_belegart <> 6
            -- wenn genau eine LFS-Position (also die erste erzeugte)
            AND (
                SELECT count(*)
                FROM belegpos
                WHERE belp_dokument_id = _docRec.beld_id
            ) = 1
          ;

      END IF;


      RETURN _posid;
  END $$ LANGUAGE plpgsql VOLATILE;

/****************************Lieferscheinposition aus Auftrag*****************************/
CREATE OR REPLACE FUNCTION TBeleg.LiefPosFromAuftg(IN Auftgdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$ /*TWawi*/
 DECLARE rec         RECORD;
         docRec      RECORD;
         frei        BOOLEAN;
         belegid     INTEGER;
         posid       INTEGER;
         uebernommen NUMERIC;
         uebernahme  NUMERIC;
         menge_gme   NUMERIC;
 BEGIN
  -- Wir sammeln mal alle möglichen Daten im System
  SELECT ag_akbz AS akbez,
         --Versandart holen, versuchen V_ID zu finden.
         COALESCE(atd_vers, a1_vers) AS versart,
         COALESCE(atd_v_id, (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))) as versartID,
         COALESCE(ag_stk, 0) as stk, ag_id,  ag_nr, ag_pos,
         ag_mcv, ag_lkn, ag_krzl, ag_krzf, ag_stk_uf1,
         ag_aknr, ag_an_nr, ag_kdatum, ag_ldatum, ag_datum,
         ag_bda,ag_bdapos, IFTHEN(TSystem.Settings__GetBool('lifsch_dont_use_auftgtxt'),
        (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txt,
        COALESCE(ag_txt, (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txt)) as dokutxt,
        IFTHEN(TSystem.Settings__GetBool('lifsch_dont_use_auftgtxt'),
        (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txtrtf,
        COALESCE(ag_txt_rtf, (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txtrtf)) AS dokutxt_rtf, ag_postxt, ag_postxt_rtf, (TSystem.Settings__Get('BASIS_W')) AS waer, m_uf,
         ag_bstat, ag_bstat1, ag_bstat2 -- #7895
         INTO rec
         FROM auftg     JOIN artmgc ON ag_mcv = m_id
                        JOIN art ON ak_nr = ag_aknr
                        LEFT JOIN adk1 ON a1_krz = ag_lkn
                        LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
         WHERE auftg.dbrid = auftgdbrid;

  SELECT * INTO docRec FROM belegdokument WHERE beld_belegtyp = 'LFS' AND beld_dokunr = belegdoknr;
  SELECT bel_id INTO belegid FROM beleg WHERE bel_nummer = belegdoknr AND bel_belegtyp = docRec.Beld_belegtyp;

  -- Übernommen in GME
  SELECT SUM(belp_menge_gme) INTO uebernommen FROM belegpos WHERE belp_ag_id = rec.ag_id;

  --Zu übernehmende Menge in GME
  menge_gme:=menge / Ifthen(rec.m_uf=0,1,rec.m_uf);

  --Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
  IF (menge IS NULL) THEN
    --Uebernahme ist in ME des Wareneingangs
    uebernahme:=( rec.ag_stk * (1-COALESCE(uebernommen,0) / IfThen(rec.ag_stk_uf1 = 0, 1, rec.ag_stk_uf1)));
  ELSE
    --Wenn mehr übernommen werden soll als zugegangen abzgl. schon uebernommen, auf Restbestand zurücksetzen
    IF ((menge_gme + uebernommen) > rec.ag_stk_uf1) THEN
      uebernahme:=(rec.ag_stk_uf1 - uebernommen)*Ifthen(rec.m_uf=0,1,rec.m_uf);
    ELSE
      uebernahme:=menge;
    END IF;
  END IF;

  IF (uebernahme < 0) THEN
    uebernahme:=0;
  END IF;

  SELECT nextval('belegpos_belp_id_seq') INTO posid;

  --Belegposition mitnehmen
  INSERT INTO belegpos (
    belp_id, belp_belegtyp,belp_dokument_id,belp_beleg_id, belp_ag_id, belp_waehr,
    belp_aknr, belp_akbez, belp_mce, belp_projektnummer, belp_versandart,
    belp_versandartbem, belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
    belp_menge, belp_preiseinheit, belp_dokutxt, belp_dokutxt_rtf, belp_txt, belp_txt_rtf,
    belp_bstat, belp_bstat1, belp_bstat2
  ) VALUES (
    posid, docRec.beld_belegtyp, docRec.beld_id, belegid, rec.ag_id, rec.waer,
    rec.ag_aknr, rec.akbez, rec.ag_mcv, rec.ag_an_nr, rec.versartID,
    rec.versart, rec.ag_lkn, rec.ag_krzl, rec.ag_krzf, COALESCE(rec.ag_bda, '') || COALESCE(' / ' || rec.ag_bdapos, ''),
    uebernahme, 1, rec.dokutxt, rec.dokutxt_rtf, rec.ag_postxt, rec.ag_postxt_rtf,
    rec.ag_bstat, rec.ag_bstat1, rec.ag_bstat2 -- #7895
  );

  --//auch PrintSetting 'psPriceMainPos' übernehmen
  PERFORM TReporting.recnokeyword__print_setting__copy('auftg', rec.ag_id, 'belegpos', posid);

  RETURN  posid;
 END $$ LANGUAGE plpgsql VOLATILE;
--



CREATE OR REPLACE FUNCTION tbeleg.belegpos__string_agg_belp_pos__by_belp_lp_id__get( _belp_lp_id integer ) RETURNS varchar AS $$
-- https://redmine.prodat-sql.de/issues/16057

  SELECT
    string_agg( belp_pos, ',' ORDER BY belp_pos )
  FROM belegpos
  WHERE belp_lp_id = _belp_lp_id;
$$ LANGUAGE sql;
--


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_netto__by_belp_id__get( _belp_id integer ) RETURNS numeric
  AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Nettegewicht einer Belegposition

      SELECT
        coalesce( belp_gewicht, 0 )
      FROM belegpos
      WHERE belegpos.belp_id = _belp_id;

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_netto__by_belp_lp_id__get( _belp_lp_id integer ) RETURNS numeric
  AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Nettegewicht der Belegpositionen, die von einem bestimmten Material verpackt wurden

      SELECT
        coalesce( sum( tbeleg.belegpos__gewicht_netto__by_belp_id__get( belegpos.belp_id )), 0 )
      FROM belegpos
      WHERE belegpos.belp_lp_id = _belp_lp_id;

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_tara__by_belp_lp_id__get( _belp_lp_id integer ) RETURNS numeric
  AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Verpackungsgewicht der Belegpositionen, die von einem bestimmten Material verpackt wurden

      SELECT
        coalesce( lp_gewicht, 0 )
      FROM lifschpack
      WHERE lifschpack.lp_id = _belp_lp_id;

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_brutto__by_belp_lp_id__get( _belp_lp_id integer ) RETURNS numeric
  AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Gesamtgewicht der Belegpositionen, die von einem bestimmten Material verpackt wurden

      SELECT
          tbeleg.belegpos__gewicht_netto__by_belp_lp_id__get( _belp_lp_id )
        + tbeleg.belegpos__gewicht_tara__by_belp_lp_id__get( _belp_lp_id );

  $$ LANGUAGE sql;



CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_tara__by_belp_id__get( _belp_id integer ) RETURNS numeric
  AS $$
  DECLARE
      _belp_lp_id integer;
      _nettogewicht_in_verpackung numeric;
      _taragewicht_verpackung numeric;
      _nettogewicht_position numeric;
      _tara numeric;
  BEGIN
      -- https://redmine.prodat-sql.de/issues/16252
      -- Verpackungsgewicht einer Belegposition

      _belp_lp_id := belp_lp_id FROM belegpos WHERE belp_id = _belp_id;
      _nettogewicht_in_verpackung := tbeleg.belegpos__gewicht_netto__by_belp_lp_id__get( _belp_lp_id );

      IF _nettogewicht_in_verpackung = 0 THEN
         RETURN 0;
      END IF;

      _taragewicht_verpackung := tbeleg.belegpos__gewicht_tara__by_belp_lp_id__get( _belp_lp_id );
      _nettogewicht_position := belp_gewicht FROM belegpos WHERE belp_id = _belp_id;

      _tara := _taragewicht_verpackung * _nettogewicht_position / _nettogewicht_in_verpackung;
      RETURN coalesce( _tara, 0 );

  END $$ LANGUAGE plpgsql IMMUTABLE;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_brutto__by_belp_id__get( _belp_id integer ) RETURNS numeric
  AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Gesamtgewicht der Belegpositionen, die von einem bestimmten Material verpackt wurden

      SELECT
          tbeleg.belegpos__gewicht_netto__by_belp_id__get( _belp_id )
        + tbeleg.belegpos__gewicht_tara__by_belp_id__get( _belp_id );

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_netto__by_belp_dokument_id__get( _belp_dokument_id integer )
  RETURNS numeric AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Nettegewicht eines Belegdokuments

      SELECT sum( belp_gewicht ) FROM belegpos WHERE belp_dokument_id = _belp_dokument_id;

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_tara__by_belp_dokument_id__get( _belp_dokument_id integer )
  RETURNS numeric AS $$
      -- https://redmine.prodat-sql.de/issues/16252
      -- Nettegewicht eines Belegdokuments

      WITH
        verpackungen AS (
           -- Jede Verpackungsposition darf nur einmal berücksichtigt werden.
           SELECT DISTINCT belp_lp_id FROM belegpos WHERE belp_dokument_id = _belp_dokument_id
        )
      SELECT sum( lp_gewicht ) AS tara FROM lifschpack
      JOIN verpackungen ON verpackungen.belp_lp_id = lifschpack.lp_id;

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION tbeleg.belegpos__gewicht_brutto__by_belp_dokument_id__get( _belp_dokument_id integer )
  RETURNS numeric AS $$
    -- https://redmine.prodat-sql.de/issues/16252
    -- Bruttogewicht eines Belegdokuments

    SELECT
        tbeleg.belegpos__gewicht_netto__by_belp_dokument_id__get( _belp_dokument_id )
      + coalesce( tbeleg.belegpos__gewicht_tara__by_belp_dokument_id__get( _belp_dokument_id ), 0 );

$$ LANGUAGE sql;
--


-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT true;
